# -*- coding: utf-8 -*-

from sandbox.projects.RunPythonScript import RunPythonScript


class RunPythonScriptWithDiff(RunPythonScript):
    '''
    Run arbitrary python script, return ctx['has_diff'] = True in case of nonempty stdout
    '''

    type = 'RUN_PYTHON_SCRIPT_WITH_DIFF'

    def parse_process_stdout(self, proc):
        try:
            for line in open(proc.stdout_path, "r"):
                self.ctx['has_diff'] = True
        except:
            pass


__Task__ = RunPythonScriptWithDiff
