# -*- coding: utf-8 -*-_read_resource

import os
import shutil

from sandbox import sdk2
from sandbox.sdk2.copy import RemoteCopy

import sandbox.common.types.resource as ctr

from sandbox.projects.VideoSearch import video_resource_types as resource_types

from sandbox.projects.common import error_handlers as eh
from sandbox.projects.common.platform_api import platform_api
from sandbox.projects.common.ya_deploy import release_integration

from urlparse import urlparse

CONFIG_FILES = {
    "config": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/canonize/config",
}

class VideoBuildCanonizeConfig(platform_api.DeployToPlatformTask, sdk2.Task, release_integration.ReleaseToYaDeployTask2):
    """
        Build 
    """

    def get_stable_environments(self):
        return []

    def get_testing_environments(self):
        return []

    def get_resource_type(self):
        return resource_types.VideoCanonizeConfig

    def on_execute(self):
        resource = sdk2.ResourceData(resource_types.VideoCanonizeConfig(
            self, "video canonize config", "config"))

        self.dst_folder = str(resource.path)

        if not os.path.exists(self.dst_folder):
            os.makedirs(self.dst_folder)

        self._fill_resource()

    def on_release(self, additional_parameters):
        release_integration.ReleaseToYaDeployTask2.on_release(
            self, additional_parameters)
        platform_api.DeployToPlatformTask.on_release(
            self, additional_parameters)

    def _get_file_path(self, filename):
        return os.path.join(self.dst_folder, filename)

    def _fill_resource(self):
        for filename, src_path in CONFIG_FILES.iteritems():
            self._get_file(filename, src_path)

    def _get_file(self, filename, src_path):
        dst_path = self._get_file_path(filename)
        parsed_url = urlparse(src_path)
        if parsed_url.scheme:
            self._download_file(src_path, dst_path)
        else:
            self._get_from_resource(src_path, dst_path)

    def _download_file(self, src, dst):
        RemoteCopy(src, dst, log_dir=self.log_path())(
            timeout=RemoteCopy.DEFAULT_TIMEOUT)

    def _sync_resource(self, resource, dst_path):
        resource_data = sdk2.ResourceData(resource)
        resource_data_path = str(resource_data.path)
        if os.path.isdir(resource_data_path):
            shutil.copytree(resource_data_path, dst_path)
        else:
            shutil.copy(resource_data_path, dst_path)

    def _get_from_resource(self, src, dst_path):
        resource = sdk2.Resource.find(
            type=src, state=ctr.State.READY).order(-sdk2.Resource.id).limit(1).first()
        eh.verify(resource, "{} not found".format(src))
        self._sync_resource(resource, dst_path)

    def _get_file_by_resource_id(self, resource_id, dst_path):
        resource = sdk2.Resource.find(id=resource_id).limit(1).first()
        eh.verify(resource, "resource with id {} not found".format(resource_id))
        self._sync_resource(resource, dst_path)
