# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc
from sandbox.projects.VideoSearch import video_resource_types as resource_types
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params


class VideoBuildDocbaseBinaries(BaseMediaBuildTask):
    """
        Бинарники для построения docbase
    """

    type = 'VIDEO_BUILD_DOCBASE_BINARIES'
    execution_space = 200000

    client_tags = ctc.Tag.GENERIC & (ctc.Tag.LINUX_PRECISE | ctc.Tag.LINUX_TRUSTY)

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[build_params.StripBinaries.name] = True

    def get_binaries(self):
        return (
            resource_types.VIDEO_BIN_DOCEXPORT,
            resource_types.VIDEO_BIN_DOCFACTOR,
            resource_types.VIDEO_BIN_DOCMERGE,
            resource_types.VIDEO_BIN_FACTORS2,
            resource_types.VIDEO_BIN_INCPLANNER,
            resource_types.VIDEO_BIN_INDEXDOCS,
            resource_types.VIDEO_BIN_DSSM_CALC,
            resource_types.VIDEO_BIN_INDEXEXPORT,
            resource_types.VIDEO_BIN_INDEXFACTORS,
            resource_types.VIDEO_BIN_INDEX_TOOLS,
            resource_types.VIDEO_BIN_PRECALC,
            resource_types.VIDEO_BIN_REMAPKIWI,
            resource_types.VIDEO_BIN_SEND_HISTORY,
            resource_types.VIDEO_BIN_VDUPMR,
            resource_types.VIDEO_BIN_YT_TOOLS,
            resource_types.VIDEO_BIN_YAMR_DYNAMIZE,
            resource_types.VIDEO_BIN_YT_DYNAMIZE,
            resource_types.VIDEO_BIN_EXPAND_SRCURLS,
            resource_types.VIDEO_BIN_URLFEXPORT,
            resource_types.VIDEO_BIN_THUMBFEXPORT,
            resource_types.VIDEO_BIN_AUTHFEXPORT,
            resource_types.VIDEO_BIN_HOSTFEXPORT,
            resource_types.VIDEO_BIN_ADAPTOR,
            resource_types.VIDEO_BIN_VUSERDATA_OXYGEN,
            resource_types.VIDEO_BIN_VEGAS,
            resource_types.VIDEO_BIN_RESTORE_SEND_HISTORY,
            resource_types.VIDEO_BIN_MR_SET_OPS_RWS,
            resource_types.VIDEO_BIN_GCFACTOR,
            resource_types.VIDEO_BIN_MEDIAEXPORT,
            resource_types.VIDEO_BIN_PREPARE_VIDEOBAN,
            resource_types.VIDEO_BIN_XFACTOR_YT,
            resource_types.VIDEO_BIN_ANNFEXPORT,
            resource_types.VIDEO_BIN_ANCHORBASE,
            resource_types.VIDEO_BIN_EXTRACT_TS,
            resource_types.VIDEO_BIN_SPOK_AGGREGATE,
            resource_types.VIDEO_BIN_DUPSMERGE,
            resource_types.VIDEO_BIN_PREBUILD,
            resource_types.VIDEO_BIN_DOCSELRANK,
            resource_types.VIDEO_BIN_RELDUPMR,
            resource_types.VIDEO_BIN_SANDBOX_RESOURCE_DOWNLOADER,
            resource_types.VIDEO_BIN_SBR_CALC,
            resource_types.VIDEO_BIN_SBR_TOOL,
            resource_types.VIDEO_BIN_STORYLOG,
            resource_types.VIDEO_BIN_SNIPPETS2SAAS,
            resource_types.VIDEO_BIN_DOCOBJECT,
            resource_types.VIDEO_BIN_POSTCALC,
            resource_types.VIDEO_BIN_ROBOTMETRICS,
            resource_types.VIDEO_BIN_PORNO3,
            resource_types.VIDEO_BIN_URL2HOST,
            resource_types.VIDEO_BIN_GRATTRVIEW,
            resource_types.VIDEO_BIN_USERDATA_INDEX,
            resource_types.VIDEO_BIN_ADD_SPOK,
            resource_types.VIDEO_BIN_FUSIONEXPORT,
            resource_types.VIDEO_BIN_DOCUPDATES,
            resource_types.VIDEO_BIN_CUMSUM,
            resource_types.VIDEO_BIN_PLAYER_COVERAGE,
            resource_types.VIDEO_BIN_GRATTRGEN,
            resource_types.VIDEO_BIN_VDATAWORK,
            resource_types.VIDEO_BIN_WRITE_SENTENCE_LENGTHS,
            resource_types.VIDEO_BIN_VHAMMER,
            resource_types.VIDEO_BIN_RS_INDEX_BUILDER,
            resource_types.VIDEO_BIN_USERDATA_DL,
            resource_types.VIDEO_BIN_FLAGS_EXPORT,
            resource_types.VIDEO_BIN_FILTER_SNIPPETS,
            resource_types.VIDEO_BIN_USERDATA_MANIP,
            resource_types.VIDEO_BIN_PRINTKEYS,
            resource_types.VIDEO_BIN_TARCVIEW,
            resource_types.VIDEO_BIN_CLUSTER_STATE,
            resource_types.VIDEO_BIN_SHARD_TOOL,
            resource_types.VIDEO_BIN_YT_EXECUTABLE,
            resource_types.VIDEO_BIN_DOCDUMP,
            resource_types.MR_OBJECTS_EXTRACTOR,
            resource_types.VIDEO_BIN_WRANGLER,
            resource_types.VIDEO_BIN_VTRIEBUILDER,
            resource_types.VIDEO_BIN_PQ_REINDEX,
            resource_types.VIDEO_BIN_DIFF_KEYS,
            resource_types.VIDEO_BIN_MERGEOBJECTS,
            resource_types.VIDEO_BIN_EXTRACT_HOSTOWNERS,
            resource_types.VIDEO_BIN_THUMBS_CONSUMER,
            resource_types.VIDEO_BIN_PRECALC_PQ,
            resource_types.VIDEO_BIN_PQINDEXER,
            resource_types.VIDEO_BIN_PREPARE_DOCIDS,
            resource_types.VIDEO_BIN_DOCAUTHOR,
            resource_types.VIDEO_BIN_INDEX_SEARCHABLE,
            resource_types.VIDEO_BIN_AVA_URL_EXTRACTOR,
            resource_types.VIDEO_BIN_VHS_STATIC_FACTORS,
            resource_types.VIDEO_BIN_REMOTE_STORAGE_INDEX,
            resource_types.VIDEO_BIN_KEYPOINTS_CONVERT,
            resource_types.VIDEO_BIN_EXTRACT_SIG_URLS,
        )

    def get_configs(self):
        return (
            resource_types.VIDEO_CONFIG_CLATTRGEN,
            resource_types.VIDEO_CONFIG_SEO_QUERY,
            resource_types.VIDEO_SCRIPT_INDEX_SH,
            resource_types.VIDEO_SCRIPT_YT_SH,
            resource_types.VIDEO_CONFIG_INDEX_SHARD_TOOL,
            resource_types.VIDEO_SCRIPT_INDEX_SHARD_BUILDER,
            resource_types.VIDEO_SCRIPT_INDEX_SHARD_BUILDER_JUPITER,
            resource_types.VIDEO_SCRIPT_INDEX_SHARD_UNINSTALL,
        )


__Task__ = VideoBuildDocbaseBinaries
