# -*- coding: utf-8 -*-_read_resource

from sandbox.projects.common.BaseVideoBuildBundle import BaseVideoBuildBundle
from sandbox.projects.common.platform_api import platform_api
from sandbox.projects.common.ya_deploy import release_integration
from sandbox.projects.VideoSearch import video_resource_types as resource_types


class VideoBuildDocbaseBundle(platform_api.DeployToPlatformTask, BaseVideoBuildBundle, release_integration.ReleaseToYaDeployTask2):
    """
        Бандл для построения документной базы
    """

    class Requirements(BaseVideoBuildBundle.Requirements):
        disk_space = 16 * 1024  # 16 gb

    def get_stable_environments(self):
        return []

    def get_testing_environments(self):
        return []

    def get_resource_type(self):
        return resource_types.VideoBundleDocbase

    def get_resource_descr(self):
        return 'docbase bundle'

    def get_resource_file_name(self):
        return 'bin'

    def get_built_resources(self):
        return (
            [resource_types.VIDEO_BIN_INDEX_TOOLS, 'index_tools'],
            [resource_types.VIDEO_BIN_DOCOBJECT, 'docobject'],
            [resource_types.VIDEO_BIN_THUMBFEXPORT, 'thumbfexport'],
            [resource_types.VIDEO_BIN_VDUPMR, 'vdupmr'],
            [resource_types.VIDEO_BIN_STORYLOG, 'storylog'],
            [resource_types.VIDEO_BIN_VDATAWORK, 'vdatawork'],
            [resource_types.VIDEO_BIN_SNIPPETS2SAAS, 'snippets2saas'],
            [resource_types.VIDEO_BIN_CUMSUM, 'cumsum'],
            [resource_types.VIDEO_BIN_EXTRACT_TS, 'extract_ts'],
            [resource_types.VIDEO_BIN_INDEXEXPORT, 'indexexport'],
            [resource_types.VIDEO_BIN_DOCFACTOR, 'docfactor'],
            [resource_types.VIDEO_BIN_GCFACTOR, 'gcfactor'],
            [resource_types.VIDEO_BIN_YAMR_DYNAMIZE, 'yamr_dynamize'],
            [resource_types.VIDEO_BIN_YT_DYNAMIZE, 'yt_dynamize'],
            [resource_types.VIDEO_BIN_EXPAND_SRCURLS, 'expand_srcurls'],
            [resource_types.VIDEO_BIN_PREPARE_VIDEOBAN, 'prepare_videoban'],
            [resource_types.VIDEO_BIN_USERDATA_DL, 'userdata_dl'],
            [resource_types.VIDEO_BIN_ROBOTMETRICS, 'robotmetrics'],
            [resource_types.VIDEO_BIN_ADAPTOR, 'adaptor'],
            [resource_types.VIDEO_BIN_DOCMERGE, 'docmerge'],
            [resource_types.VIDEO_BIN_INDEXFACTORS, 'indexfactors'],
            [resource_types.VIDEO_BIN_SPOK_AGGREGATE, 'spok_aggregate'],
            [resource_types.VIDEO_BIN_YT_TOOLS, 'yt_tools'],
            [resource_types.VIDEO_BIN_AUTHFEXPORT, 'authfexport'],
            [resource_types.VIDEO_BIN_WRITE_SENTENCE_LENGTHS, 'write_sentence_lengths'],
            [resource_types.VIDEO_BIN_URL2HOST, 'url2host'],
            [resource_types.VIDEO_BIN_FUSIONEXPORT, 'fusionexport'],
            [resource_types.VIDEO_BIN_FILTER_SNIPPETS, 'filter_snippets'],
            [resource_types.VIDEO_BIN_ADD_SPOK, 'add_spok'],
            [resource_types.VIDEO_BIN_PREBUILD, 'prebuild'],
            [resource_types.VIDEO_BIN_PRECALC, 'precalc'],
            [resource_types.VIDEO_BIN_SBR_TOOL, 'sbr_tool'],
            [resource_types.VIDEO_BIN_DOCSELRANK, 'docselrank'],
            [resource_types.VIDEO_BIN_VUSERDATA_OXYGEN, 'vuserdata_oxygen'],
            [resource_types.VIDEO_BIN_GRATTRVIEW, 'grattrview'],
            [resource_types.VIDEO_BIN_URLFEXPORT, 'urlfexport'],
            [resource_types.VIDEO_BIN_FLAGS_EXPORT, 'flags_export'],
            [resource_types.VIDEO_BIN_VHAMMER, 'vhammer'],
            [resource_types.VIDEO_BIN_INDEXDOCS, 'indexdocs'],
            [resource_types.VIDEO_BIN_DSSM_CALC, 'dssm_calc'],
            [resource_types.VIDEO_BIN_DOCEXPORT, 'docexport'],
            [resource_types.VIDEO_BIN_GRATTRGEN, 'grattrgen'],
            [resource_types.VIDEO_BIN_RESTORE_SEND_HISTORY, 'restore_send_history'],
            [resource_types.VIDEO_BIN_DOCUPDATES, 'docupdates'],
            [resource_types.VIDEO_BIN_INCPLANNER, 'incplanner'],
            [resource_types.VIDEO_BIN_PORNO3, 'porno3'],
            [resource_types.VIDEO_BIN_REMAPKIWI, 'remapkiwi'],
            [resource_types.VIDEO_BIN_ANNFEXPORT, 'annfexport'],
            [resource_types.VIDEO_BIN_SEND_HISTORY, 'send_history'],
            [resource_types.VIDEO_BIN_SBR_CALC, 'sbr_calc'],
            [resource_types.VIDEO_BIN_FACTORS2, 'factors2'],
            [resource_types.VIDEO_BIN_DUPSMERGE, 'dupsmerge'],
            [resource_types.VIDEO_BIN_ANCHORBASE, 'anchorbase'],
            [resource_types.VIDEO_BIN_XFACTOR_YT, 'xfactor-yt'],
            [resource_types.VIDEO_BIN_HOSTFEXPORT, 'hostfexport'],
            [resource_types.VIDEO_BIN_USERDATA_INDEX, 'userdata_index'],
            [resource_types.VIDEO_BIN_POSTCALC, 'postcalc'],
            [resource_types.VIDEO_BIN_RELDUPMR, 'reldupmr'],
            [resource_types.VIDEO_BIN_VEGAS, 'vegas'],
            [resource_types.VIDEO_BIN_PLAYER_COVERAGE, 'player_coverage'],
            [resource_types.VIDEO_BIN_MEDIAEXPORT, 'mediaexport'],
            [resource_types.VIDEO_BIN_CLUSTER_STATE, 'cluster_state'],
            [resource_types.VIDEO_BIN_DOCDUMP, 'docdump'],
            [resource_types.MR_OBJECTS_EXTRACTOR, 'mrobjectsextractor'],
            [resource_types.VIDEO_BIN_VTRIEBUILDER, 'vtriebuilder'],
            [resource_types.VIDEO_BIN_PQ_REINDEX, 'pq_reindex'],
            [resource_types.VIDEO_BIN_DIFF_KEYS, 'diff_keys'],
            [resource_types.VIDEO_BIN_MERGEOBJECTS, 'mergeobjects'],
            [resource_types.VIDEO_BIN_EXTRACT_HOSTOWNERS, 'extract_hostowners'],
            [resource_types.VIDEO_BIN_PREPARE_DOCIDS, 'prepare_docids'],
            [resource_types.VIDEO_BIN_DOCAUTHOR, 'docauthor'],
            [resource_types.VIDEO_BIN_INDEX_SEARCHABLE, 'index_searchable'],
            [resource_types.VIDEO_BIN_AVA_URL_EXTRACTOR, 'ava_url_extractor'],
            [resource_types.VIDEO_BIN_VHS_STATIC_FACTORS, 'vhs_static_factors'],
            [resource_types.VIDEO_BIN_REMOTE_STORAGE_INDEX, 'remote_storage_index'],
            [resource_types.VIDEO_BIN_KEYPOINTS_CONVERT, 'keypoints_convert'],
            [resource_types.VIDEO_BIN_EXTRACT_SIG_URLS, 'extract_sig_urls'],
        )

    def on_release(self, additional_parameters):
        release_integration.ReleaseToYaDeployTask2.on_release(self, additional_parameters)
        platform_api.DeployToPlatformTask.on_release(self, additional_parameters)
