# -*- coding: utf-8 -*-_read_resource

import os
import shutil

from sandbox import sdk2
from sandbox.sdk2.copy import RemoteCopy

import sandbox.common.types.resource as ctr

from sandbox.projects.VideoSearch import video_resource_types as resource_types

from sandbox.projects.common import error_handlers as eh
from sandbox.projects.common.platform_api import platform_api
from sandbox.projects.common.ya_deploy import release_integration

from urlparse import urlparse

CONFIG_FILES = {"adult_over_vpq3.vwbin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/adult_over_vpq3.vwbin",
                "adult_over_vpq4.vwbin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/adult_over_vpq4.vwbin",
                "adult_over_vpq5.vwbin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/adult_over_vpq5.vwbin",
                "adult_over_wr.vwbin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/adult_over_wr.vwbin",
                "adv_partner_host.whitelist": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/adv_partner_host.whitelist",
                "areas.lst": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/canonize/config/areas.lst",
                "authorized_hosts.lst": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/authorized_hosts.lst",
                "bigrams.gz": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/bigrams.gz",
                "categ": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/categ",
                "categ.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/categ.cfg",
                "canonizers.xml": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/player/canonizers.xml",
                "connectors_urlbase.xml": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/player/connectors_urlbase.xml",
                "content_attrs": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/frames/content_attrs",
                "datescleaner.repat": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/series/datescleaner.repat",
                "dict.dict": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/recognize/dict.dict",
                "document_platforms.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/document_platforms.cfg",
                "document_platforms_dynamic.cfg": "VIDEO_DOCUMENT_PLATFORMS_CFG",
                "english_video_title_keywords.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/english_video_title_keywords.txt",
                "gruesome": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/extsearch/video/quality/vegas/config/gruesome",
                "gruesome.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/extsearch/video/quality/vegas/config/gruesome.cfg",
                "hard_porno": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/extsearch/video/quality/vegas/config/hard_porno",
                "hard_porno.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/extsearch/video/quality/vegas/config/hard_porno.cfg",
                "hostban.lst": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/hostban.lst",
                "hostingconverter.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/hostingconverter.txt",
                "hostings.whitelist.durs.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/hostings.whitelist.durs.txt",
                "html5whitelist.flt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/html5whitelist.flt",
                "html5_host.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/html5_host.cfg",
                "iconfiguration.cfg": "VIDEO_CONFIG_ICONFIGURATION",
                "i2t.dict": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/i2t.dict",
                "lang2region.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/lang2region.txt",
                "lemmas_merger_index": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/lemmas_merger_index",
                "markers.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/series/markers.cfg",
                "mobileapp_whitelist.flt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/mobileapp_whitelist.flt",
                "news_hosts.flt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/news_hosts.flt",
                "owner-dup-texts": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/mediamr/config/owner-dup-texts",
                "oxyjoin.fresh.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/oxyjoin.fresh.cfg",
                "oxyjoin.ultra.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/oxyjoin.ultra.cfg",
                "porno.gzt.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/search/wizard/data/wizard/AdultRule/porno.gzt.bin",
                "pornosusp.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/pornosusp.txt",
                "porno": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/extsearch/video/quality/vegas/config/porno",
                "porno.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/extsearch/video/quality/vegas/config/porno.cfg",
                "porno_host.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/extsearch/video/quality/vegas/config/porno_host.cfg",
                "pq_reindex.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/extsearch/video/robot/index/pq_reindex/pq_reindex.cfg",
                "vhs_pq_reindex.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/extsearch/video/robot/index/pq_reindex/vhs_pq_reindex.cfg",
                "pure": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/pure",
                "quality": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/quality",
                "quality.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/quality.cfg",
                "queryrec.dict": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/wizard/language/queryrec.dict",
                "queryrec.filters": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/wizard/language/queryrec.filters",
                "queryrec.weights": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/wizard/language/queryrec.weights",
                "relev_regions.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/relev_regions.txt",
                "rus.repat": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/series/rus.repat",
                "semantic.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/semantic.cfg",
                "series.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/series/series.cfg",
                "seriesmr.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/series/seriesmr.cfg",
                "simple_owners.lst": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/canonize/config/simple_owners.lst",
                "smarttv_whitelist.flt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/smarttv_whitelist.flt",
                "spamwhitelist.flt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/canonize/config/spamwhitelist.flt",
                "rkn_ban.json": "VIDEO_RKN_BAN",
                "stopwords.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/userdata/config/stopwords.txt",
                "tag.trie": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/extsearch/video/robot/docbase/library/precalc/ut/data/tag.trie",
                "textfactors.repat": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/series/textfactors.repat",
                "trigramSkipHosts.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/trigramSkipHosts.txt",
                "trigramSkipHosts.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/trigramSkipHosts.txt",
                "trust.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/trust.cfg",
                "trustedvideo.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/mediamr/config/trustedvideo.cfg",
                "tur.repat": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/series/tur.repat",
                "uidvswitch.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/mediamr/config/uidvswitch.cfg",
                "urlban.lst": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/urlban.lst",
                "url_generators.def": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/canonize/config/url_generators.def",
                "urlsconvert.srcurl.re": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/canonize/config/urlsconvert.srcurl.re",
                "urlsconvert.thumbs.re": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/canonize/config/urlsconvert.thumbs.re",
                "urlsconvert.urls.re": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/canonize/config/urlsconvert.urls.re",
                "urlsconvert.original2thumb.re": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/canonize/config/urlsconvert.original2thumb.re",
                "urlsconvert.parsedurl.re": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/canonize/config/urlsconvert.parsedurl.re",
                "vh_tag_data.json": "VIDEO_VH_TAG_DATA",
                "top_content_authors_data.json": "VIDEO_VH_TOP_CONTENT_AUTHORS",
                "videofacts.pat": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/series/videofacts.pat",
                "videofacts.re": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/series/videofacts.re",
                "videotop.lst": "VIDEO_VIDEOTOP_LST_CONFIG",
                "video_page_quality.info": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/video_page_quality.info",
                "video_page_quality_v2.info": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/models/video_page_quality_v2.info",
                "ytnewsusers.lst": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/ytnewsusers.lst",
                "w2v.model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/extsearch/video/quality/vegas/config/w2v.model.bin",
                "whitehosts.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/whitehosts.txt",
                "host_skip_texts.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/host_skip_texts.cfg",
                "offered-whitehosts": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/offered-whitehosts",
                "offered-whitehosts.premium": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/offered-whitehosts.premium",
                "fltic_over30.txt": "VIDEO_TIC_OVER30",
                "geoa.c2p": "VIDEO_CONFIG_GEOA_C2P",
                "geodata5.bin": "GEODATA5BIN_STABLE",
                "mask_export.trie": "VIDEO_DOCBASE_MASK_TRIE",
                "owner_export.trie": "VIDEO_DOCBASE_OWNER_TRIE",
                "serialsyns.trie": "VIDEO_SERIALSYNS_TRIE",
                "serials.trie": "VIDEO_SERIALS_TRIE",
                "serials.txt": "VIDEO_SERIALS_TXT",
                "zoradnsban.trie": "VIDEO_ZORADNSBAN_TRIE",
                "connectors_raw.xml": "VIDEO_CONFIG_AUTOPLAYER",
                "player_unban.json": "VIDEO_CONFIG_UNBAN",
                "pq_web.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/page_quality/pq_web.dssm",
                "t2q-docPart.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/t2q-docPart.cfg",
                "t2q.LowerLetterTrigrams.111": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/t2q.LowerLetterTrigrams.111",
                "t2q.LowerWordsUrls.111": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/t2q.LowerWordsUrls.111",
                "t2q.LowerWords.111": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/t2q.LowerWords.111",
                "title2query.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/title2query.cfg",
                "title2query.net": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/title2query.net",
                "title2query-300-10.ckmeans": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/title2query-300-10.ckmeans",
                "video-dc-qt-120.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/video-dc-qt-120.dssm",
                "video-dc-qt-120-15.ckmeans": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/video-dc-qt-120-15.ckmeans",
                "web-model-dt-300.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/web-model-dt-300.dssm",
                "web-dt-300-15.ckmeans": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/web-dt-300-15.ckmeans",
                "web-reformulations.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/web-reformulations.dssm",
                "web-reformulations-120-30.ckmeans": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/web-reformulations-120-30.ckmeans",
                "video-reformulations.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/video-reformulations.dssm",
                "video-reformulations-120-20.ckmeans": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/video-reformulations-120-20.ckmeans",
                "web-bert-relev.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/web-bert-relev.dssm",
                "web-bert-relev-120-24.ckmeans": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/web-bert-relev-120-24.ckmeans",
                "cv-porno-tags-names": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/cv-porno-tags-names",
                "cv-porno-studios-names": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/cv-porno-studios-names",
                "cv-porno-actors-faces-names": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/vparser/porno-actors/idx2name",
                "tags_actor.trie": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/object_tags/tags_actor.trie",
                "tags_composer.trie": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/object_tags/tags_composer.trie",
                "tags_director.trie": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/object_tags/tags_director.trie",
                "tags_genre.trie": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/object_tags/tags_genre.trie",
                "author_slice.lst": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/author_slice.lst",
                "author_slice_youtube.lst": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/author_slice_youtube.lst",
                "kids_channels.lst": "VIDEO_CONFIG_KIDS_CHANNELS",
                "kids_stopwords.re": "VIDEO_CONFIG_KIDS_STOPWORDS",
                "thumbs_items": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/thumbless_thumbs_items",
                "fake_thumbs_whitelist": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/fake_thumbs_whitelist",
                "series_navigator.trie": "VIDEO_CONFIG_SERIES_NAVIGATOR_TRIE",
                "dates_extractor.re": "VIDEO_CONFIG_DATES_EXTRACTOR",
                "voiceover_studio_regexp.txt": "VIDEO_CONFIG_VOICEOVERSTUDIO_REGEXP",
                "voiceover_hosts.txt": "VIDEO_CONFIG_VOICEOVER_HOSTS",
                "voiceover_studio_whitelist.txt": "VIDEO_CONFIG_VOICEOVERSTUDIO_WHITELIST",
                "genre_parent_links.json": "VIDEO_CONFIG_WIDE_QUERY_GENRE_PARENT_LINKS",
                "genre_and_links.json": "VIDEO_CONFIG_WIDE_QUERY_GENRE_AND_LINKS",
                "genre_index.json": "VIDEO_CONFIG_WIDE_QUERY_GENRE_INDEX",
                "country_index.json": "VIDEO_CONFIG_WIDE_QUERY_COUNTRY_INDEX",
                "video-dc-qt-288.dssm": "VIDEO_CONFIG_CATEG_DSSM",
                "categ_short_road_map_l1.json": "VIDEO_CONFIG_CATEG_VIEWS",
                "categ_parent_links.json": "VIDEO_CONFIG_CATEG_PARENT_LINKS",
                "channels_data.json": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/search/web/rearrs_upper/rearrange.dynamic/tv_broadcasting/channels_data.json",
                "releasedate.re": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/series/releasedate.re",
                "releasedate.pat": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/webscripts/video/index/config/series/releasedate.pat",
                "toloka.dssm": "VIDEO_CONFIG_TOLOKA_DSSM",
                "indexknn.20.ckmeans": "VIDEO_CONFIG_INDEX_KNN_CKMEANS",
                "knnfps.dssm": "VIDEO_CONFIG_KNN_FPS_DSSM",
                "knnfps.10.ckmeans": "VIDEO_CONFIG_KNN_FPS_CKMEANS",
                "personal_vhs_user2doc.dssm": "VIDEO_CONFIG_PERSONAL_MODEL",
                "tag_freq.trie": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/postcalc/tag_freq.trie",
                "adult_tags.gzt.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/postcalc/adult_tags.gzt.bin",
                "doc-nn-over-dssm.pb": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/nn_over_dssm/doc.pb",
                "doc-nn-over-dssm.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/nn_over_dssm/doc.dssm",
                "doc-nn-over-dssm-exp.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/nn_over_dssm/doc-exp.dssm",
                "doc-nn-over-dssm-extra1.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/nn_over_dssm/doc-extra1.dssm",
                "doc-nn-over-dssm-extra2.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/nn_over_dssm/doc-extra2.dssm",
                "doc-nn-over-dssm-extra3.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/nn_over_dssm/doc-extra3.dssm",
                "adv_tags": "VIDEO_CONFIG_ADV_TAGS",
                "adv_categs": "VIDEO_CONFIG_ADV_CATEGS",
                "zen_categs_gif": "ZEN_CATEG_GIF_BUNDLE",
                "vpq-200-20.ckmeans": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/vpq-200-20.ckmeans",
                "vpq_v2-240-40.ckmeans": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/vpq_v2-240-40.ckmeans",
                "vpq_v3-256-40.ckmeans": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/vpq_v3-256-40.ckmeans",
                "vpq_v4-240-80.ckmeans": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/vpq_v4-240-80.ckmeans",
                "vh_static_features": "VIDEO_VIDEOHUB_STATIC_CONFIG_BUNDLE",
                "bs_categs_by_kinopoisk_id.json": "VIDEO_BS_CATEGS_BY_KINOPOISK_ID",
                "brand_safety_markup_by_content_id.json": "VIDEO_BS_CATEGS_BY_CONTENT_ID",
                "brand_safety_markup_by_author_id.json": "VIDEO_BS_CATEGS_BY_AUTHOR_ID",
                "brand_safety_markup_by_channel_id.json": "VIDEO_BS_CATEGS_BY_CHANNEL_ID",
                "vpq_v5-256-80.ckmeans": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/vpq_v5-256-80.ckmeans",
                "vpq_v5-240-80.ckmeans": "svn+ssh://arcadia.yandex.ru/arc/trunk/data/video/nn_models/all_plus_query/videovec/vpq_v5-240-80.ckmeans",
                "brand_safety_forbidden_categs_for_kinopoisk.json": "VIDEO_BS_FORBIDDEN_CATEGS_FOR_KINOPOISK_CONTENT",
}


CONFIG_FILES_BY_RESOURCE_ID = {
    "web-logdt-bigram-doc-50.dssm": 315362980,
    "lang_detector.archive": 3166329239
}


class VideoBuildDocbaseConfig(platform_api.DeployToPlatformTask, sdk2.Task, release_integration.ReleaseToYaDeployTask2):
    """
        сборка конфигов docbase
    """

    def get_stable_environments(self):
        return []

    def get_testing_environments(self):
        return []

    def get_resource_type(self):
        return resource_types.VideoConfigDocbase

    def on_execute(self):
        resource = sdk2.ResourceData(resource_types.VideoConfigDocbase(
            self, "video docbase config", "config"))

        self.dst_folder = str(resource.path)

        if not os.path.exists(self.dst_folder):
            os.makedirs(self.dst_folder)

        self._fill_resource()

    def on_release(self, additional_parameters):
        release_integration.ReleaseToYaDeployTask2.on_release(self, additional_parameters)
        platform_api.DeployToPlatformTask.on_release(self, additional_parameters)

    def _get_file_path(self, filename):
        return os.path.join(self.dst_folder, filename)

    def _fill_resource(self):
        for filename, src_path in CONFIG_FILES.iteritems():
            self._get_file(filename, src_path)
        for filename, resource_id in CONFIG_FILES_BY_RESOURCE_ID.iteritems():
            self._get_file_by_resource_id(resource_id, self._get_file_path(filename))

    def _get_file(self, filename, src_path):
        dst_path = self._get_file_path(filename)
        parsed_url = urlparse(src_path)
        if parsed_url.scheme:
            self._download_file(src_path, dst_path)
        else:
            self._get_from_resource(src_path, dst_path)

    def _download_file(self, src, dst):
        RemoteCopy(src, dst, log_dir=self.log_path())(timeout=RemoteCopy.DEFAULT_TIMEOUT)

    def _sync_resource(self, resource, dst_path):
        resource_data = sdk2.ResourceData(resource)
        resource_data_path = str(resource_data.path)
        if os.path.isdir(resource_data_path):
            shutil.copytree(resource_data_path, dst_path)
        else:
            shutil.copy(resource_data_path, dst_path)

    def _get_from_resource(self, src, dst_path):
        resource = sdk2.Resource.find(type=src, state=ctr.State.READY).order(-sdk2.Resource.id).limit(1).first()
        eh.verify(resource, "{} not found".format(src))
        self._sync_resource(resource, dst_path)

    def _get_file_by_resource_id(self, resource_id, dst_path):
        resource = sdk2.Resource.find(id=resource_id).limit(1).first()
        eh.verify(resource, "resource with id {} not found".format(resource_id))
        self._sync_resource(resource, dst_path)
