# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from os.path import join, basename
import sandbox.projects.resource_types.releasers as resource_releasers
from sandbox.projects.common import error_handlers as eh


class VideoConfigIconfiguration(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers


class VideoBuildIconfiguration(sdk2.Task):
    '''Apply SPOK quotas, generate iconfiguration.cfg'''

    def get_configs(self):
        return (
            "arc/trunk/arcadia/yweb/webscripts/video/index/config/iconfiguration.cfg.pattern",
            "arc/trunk/arcadia/quality/spok/dict/NationalDomains.tsv",
            "arc/trunk/arcadia/quality/spok/dict/CountryLanguages.tsv",
            "arc/trunk/arcadia/yweb/webscripts/video/spok/stats_countries.txt",
            "arc/trunk/arcadia/yweb/webscripts/video/spok/add_langs.tsv",
            "robots/trunk/wizard-data/spok/countries.txt",
        )

    def export_configs(self, path):
        for config in self.get_configs():
            sdk2.svn.Arcadia.export("arcadia:/{}".format(config), join(path, basename(config)))

    def get_add_spok(self):
        add_spok_resource = sdk2.Resource.find(type='VIDEO_BIN_ADD_SPOK', attrs={"released": "stable"}).first()
        eh.verify(add_spok_resource, "add_spok not found")
        sync_path = str(sdk2.ResourceData(add_spok_resource).path)
        logging.info("using add_spok %s, res_id %s; sync_path %s", add_spok_resource, add_spok_resource.id, sync_path)
        return sync_path

    def on_execute(self):
        resource = sdk2.ResourceData(VideoConfigIconfiguration(
            self, "iconfiguration.cfg", "iconfiguration.cfg"))
        logging.info(resource.path)
        tmp_path = str(self.path("tmp"))
        self.export_configs(tmp_path)
        add_spok_path = self.get_add_spok()
        with open(str(resource.path), "w") as fd:
            proc = sp.Popen([add_spok_path,
                "-i", join(tmp_path, "iconfiguration.cfg.pattern"),
                "-c", join(tmp_path, "countries.txt"),
                "-d", join(tmp_path, "NationalDomains.tsv"),
                "-l", join(tmp_path, "CountryLanguages.tsv"),
                "-s", join(tmp_path, "stats_countries.txt"),
                "-l", join(tmp_path, "add_langs.tsv"),
                "--verbose"], stdout=fd)
            proc.wait()
            eh.verify(proc.returncode == 0, "add_spok failed")
