# -*- coding: utf-8 -*-

from sandbox.projects.VideoSearch import video_resource_types as resource_types
from sandbox.projects import resource_types as deprecated_resource_types

from sandbox.projects.common.BaseVideoBuildBundle import BaseVideoBuildBundle
from sandbox.projects.common.nanny import nanny

from sandbox.projects.VideoSearch.VideoBuildIconfiguration import VideoConfigIconfiguration, VideoBuildIconfiguration

from sandbox.projects.VideoSearch.VideoBuildIndexKnnCkmeansModel import VideoIndexKnnCkmeansModel, VideoBuildIndexKnnCkmeansModel
from sandbox.projects.VideoSearch.VideoBuildIndexKnnDssmModel import VideoIndexKnnDssmModel, VideoBuildIndexKnnDssmModel
from sandbox.projects.VideoSearch.VideoBuildIndexKnnRankingCkmeansModel import VideoIndexKnnRankingCkmeansModel, VideoBuildIndexKnnRankingCkmeansModel
from sandbox.projects.VideoSearch.VideoBuildIndexKnnUser2DocCkmeansModel import VideoIndexKnnUser2DocCkmeansModel, VideoBuildIndexKnnUser2DocCkmeansModel


class VideoBuildIndexBundle(nanny.ReleaseToNannyTask2, BaseVideoBuildBundle):
    """
        Бандл для построения индекса
    """

    class Requirements(BaseVideoBuildBundle.Requirements):
        disk_space = 8 * 1024  # 8 gb

    def get_built_resources(self):
        return (
            [resource_types.VIDEO_BIN_GRATTRGEN, 'bin/mr-indexer-stable/grattrgen'],
            [resource_types.VIDEO_BIN_GRATTRVIEW, 'bin/mr-indexer-stable/grattrview'],
            [resource_types.VIDEO_BIN_PRINTKEYS, 'bin/mr-indexer-stable/printkeys'],
            [resource_types.VIDEO_BIN_TARCVIEW, 'bin/mr-indexer-stable/tarcview'],
            [resource_types.VIDEO_BIN_URL2HOST, 'bin/mr-indexer-stable/url2host'],
            [resource_types.VIDEO_BIN_USERDATA_DL, 'bin/mr-indexer-stable/userdata_dl'],
            [resource_types.VIDEO_BIN_USERDATA_MANIP, 'bin/mr-indexer-stable/userdata_manip'],
            [resource_types.VIDEO_BIN_VDATAWORK, 'bin/mr-indexer-stable/vdatawork'],
            [resource_types.VIDEO_BIN_VHAMMER, 'bin/mr-indexer-stable/vhammer'],
            [resource_types.VIDEO_BIN_RS_INDEX_BUILDER, 'bin/mr-indexer-stable/rs_index_builder'],
            [resource_types.VIDEO_BIN_WRANGLER, 'bin/mr-indexer-stable/wrangler'],
            [resource_types.VIDEO_BIN_WRITE_SENTENCE_LENGTHS, 'bin/mr-indexer-stable/write_sentence_lengths'],
            [resource_types.VIDEO_BIN_SHARD_TOOL, 'shard_tool'],
            [resource_types.VIDEO_BIN_YT_EXECUTABLE, 'yt'],

            [resource_types.VIDEO_CONFIG_CLATTRGEN, 'config/clattrgen.cfg'],
            [resource_types.VIDEO_CONFIG_SEO_QUERY, 'config/seo.query'],

            [resource_types.VIDEO_SCRIPT_INDEX_SH, 'cm/index_yt.sh'],
            [resource_types.VIDEO_SCRIPT_YT_SH, 'cm/yt.sh'],

            [resource_types.VIDEO_CONFIG_INDEX_SHARD_TOOL, 'config.json'],
            [resource_types.VIDEO_SCRIPT_INDEX_SHARD_UNINSTALL, 'resources/shard-uninstall.sh'],
            [resource_types.VIDEO_SCRIPT_INDEX_SHARD_BUILDER, 'shard_builder.sh'],
            [resource_types.VIDEO_SCRIPT_INDEX_SHARD_BUILDER_JUPITER, 'shard_builder_jupiter.sh'],
        )

    def get_resources(self):
        return (
            [VideoConfigIconfiguration, VideoBuildIconfiguration.type, 'config/iconfiguration.cfg'],

            [deprecated_resource_types.VIDEO_PANTHER_OFFROAD_INDEX_INV_MODEL, None, 'config/indexpanther.offroad.inv.model'],
            [deprecated_resource_types.VIDEO_PANTHER_OFFROAD_INDEX_KEY_MODEL, None, 'config/indexpanther.offroad.key.model'],

            [resource_types.VIDEO_CONFIG_QUERYREC_DICT, None, 'config/queryrec.dict'],
            [resource_types.VIDEO_CONFIG_QUERYREC_FILTERS, None, 'config/queryrec.filters'],
            [resource_types.VIDEO_CONFIG_QUERYREC_WEIGHTS, None, 'config/queryrec.weights'],
            [resource_types.VIDEO_CONFIG_GEOA_C2P, None, 'resources/pure/geoa.c2p'],
            [VideoIndexKnnDssmModel, VideoBuildIndexKnnDssmModel.type, 'config/indexknn.dssm'],
            [VideoIndexKnnCkmeansModel, VideoBuildIndexKnnCkmeansModel.type, 'config/indexknn.ckmeans'],
            [VideoIndexKnnRankingCkmeansModel, VideoBuildIndexKnnRankingCkmeansModel.type, 'config/ranking.ckmeans'],
            [VideoIndexKnnUser2DocCkmeansModel, VideoBuildIndexKnnUser2DocCkmeansModel.type, 'config/indexknn.user2doc.ckmeans']
        )

    def get_resource_type(self):
        return resource_types.VideoBundleIndex

    def get_resource_descr(self):
        return 'Index deploy bundle'

    def get_resource_file_name(self):
        return 'bundle'
