# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class VideoIndexKnnDssmModel(sdk2.Resource):
    releasable = True
    releasers = list(set(resource_releasers.video_robot_releasers + resource_releasers.video))


class VideoBuildIndexKnnDssmModel(sdk2.Task):
    '''Export DSSM model for indexknn'''

    def get_model_path(self):
        return "arc/trunk/data/video/nn_models/all_plus_query/videovec/video-dc-qt-120.dssm"

    def export_configs(self, path):
        model_path = self.get_model_path()
        sdk2.svn.Arcadia.export("arcadia:/{}".format(model_path), str(path))

    def on_execute(self):
        resource = sdk2.ResourceData(VideoIndexKnnDssmModel(
            self, "DSSM model for indexknn", "indexknn.dssm"))

        self.export_configs(resource.path)

        resource.ready()
