# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as resource_releasers


class VideoIndexKnnUser2DocCkmeansModel(sdk2.Resource):
    releasable = True
    releasers = list(set(resource_releasers.video_robot_releasers + resource_releasers.video))


class VideoBuildIndexKnnUser2DocCkmeansModel(sdk2.Task):
    '''Export CKmeans model for indexknn.user2doc'''

    def get_model_path(self):
        return "arc/trunk/data/video/nn_models/related/indexknn.user2doc.ckmeans"

    def export_configs(self, path):
        model_path = self.get_model_path()
        sdk2.svn.Arcadia.export("arcadia:/{}".format(model_path), str(path))

    def on_execute(self):
        resource = sdk2.ResourceData(VideoIndexKnnUser2DocCkmeansModel(
            self, "Ckmeans model for indexknn.user2doc", "indexknn.user2doc.ckmeans"))

        self.export_configs(resource.path)

        resource.ready()
