# -*- coding: utf-8 -*-

from sandbox.projects import VideoBuildDynamicModels
from sandbox.projects import BuildDynamicModels
from sandbox.projects.common.search import settings as media_settings
from sandbox.projects.VideoSearch import video_resource_types

from sandbox.sandboxsdk.parameters import SandboxSvnUrlParameter
from sandbox.sandboxsdk.parameters import SandboxBoolParameter


class ModelsUrlForProduction(SandboxSvnUrlParameter):
    """
        SVN URL для продакшн формул
    """
    name = 'models_svn_url_production'
    description = 'production models svn url (get latest released if empty)'
    default_value = media_settings.VideoSettings.MODELS_HUB_MODELS_SVN_PRODUCTION_TRUNK_URL
    required = False


class ModelsUrlForExperiment(SandboxSvnUrlParameter):
    """
        SVN URL для экспериментальных формул
    """
    name = 'models_svn_url_experiment'
    description = 'experiment models svn url (get latest if empty)'
    default_value = None
    required = False


class CheckProductionModelsList(SandboxBoolParameter):
    name = 'check_production_models_list'
    description = 'Check that production models contain Hast, Wizard and fast models'
    default_value = False


class StrictFormulaIdChecks(SandboxBoolParameter):
    name = 'strict_check_formula_id'
    description = 'Checks that all formulas contain ID and throws exception if true.'
    default_value = False


class ModelsCustom(SandboxBoolParameter):
    name = 'custom_models'
    description = 'add custom models from svn'
    default_value = False


class VideoBuildModelsHubDynamicModels(VideoBuildDynamicModels.VideoBuildDynamicModels):
    """
        Таск выкачивает модели models_hub из SVN по указанному URL
        и собирает их в архив с помощью tools/archiver
    """

    type = 'VIDEO_BUILD_MODELS_HUB_DYNAMIC_MODELS'

    description = 'Dynamic models archive for video models_hub'

    resourse_type = video_resource_types.VIDEO_MODELS_HUB_DYNAMIC_MODELS_ARCHIVE

    archive_name = 'mh_models.archive'

    input_parameters = (
        BuildDynamicModels.ModelsForProduction,
        ModelsUrlForProduction,
        BuildDynamicModels.ModelsForExperiment,
        ModelsUrlForExperiment,
        CheckProductionModelsList,
        StrictFormulaIdChecks,
        ModelsCustom,
        VideoBuildDynamicModels.FailWithoutSlices,
        VideoBuildDynamicModels.Deduplicate,
        BuildDynamicModels.ModelsUrls,
        BuildDynamicModels.CheckSize,
        BuildDynamicModels.MaxArchiveSize,
    )

    def get_resource_type(self):
        return 'VIDEO_MODELS_HUB_DYNAMIC_MODELS_ARCHIVE'


__Task__ = VideoBuildModelsHubDynamicModels
