# -*- coding: utf-8 -*-_read_resource

from sandbox.projects.common.BaseVideoBuildBundle import BaseVideoBuildBundle
from sandbox.projects.common.platform_api import platform_api
from sandbox.projects.common.ya_deploy import release_integration
from sandbox.projects.VideoSearch import video_resource_types as resource_types


class VideoBuildPqBundle(platform_api.DeployToPlatformTask, BaseVideoBuildBundle, release_integration.ReleaseToYaDeployTask2):
    """
        Бандл для построение PQ контуров
    """

    class Requirements(BaseVideoBuildBundle.Requirements):
        disk_space = 16 * 1024  # 16 gb

    def get_stable_environments(self):
        return []

    def get_testing_environments(self):
        return []

    def get_resource_type(self):
        return resource_types.VideoIndexPqBundle

    def get_resource_descr(self):
        return 'video index pq bundle'

    def get_resource_file_name(self):
        return 'bin'

    def get_built_resources(self):
        return (
            [resource_types.VIDEO_BIN_THUMBS_CONSUMER, 'thumbs_consumer'],
            [resource_types.VIDEO_BIN_PRECALC_PQ, 'precalc_pq'],
            [resource_types.VIDEO_BIN_PQINDEXER, 'pqindexer']
        )

    def on_release(self, additional_parameters):
        release_integration.ReleaseToYaDeployTask2.on_release(self, additional_parameters)
        platform_api.DeployToPlatformTask.on_release(self, additional_parameters)

