# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.VideoSearch import video_resource_types as resource_types
from sandbox.projects.common import error_handlers as eh


class VideoBuildSeriesNavigatorConfig(sdk2.Task):
    """
        Генерация конфига с сериальным навигатором
    """

    class Requirements(sdk2.Requirements):
        environments = (PipEnvironment('yandex-yt'), PipEnvironment('yandex-yt-yson-bindings-skynet'), )

    class Parameters(sdk2.Parameters):
        server = sdk2.parameters.String(
            'YT server',
            default='hahn'
        )

        src_table = sdk2.parameters.String(
            'Series navigator table path',
            default='//home/videoquality/series/exports/series_data_for_video_delayed_view'
        )

    @property
    def yt_token(self):
        return sdk2.Vault.data(self.owner, 'yt_token')

    def get_bin_series_trie(self):
        bin_series_trie = sdk2.Resource.find(type=resource_types.VIDEO_BIN_SERIES_TRIE_CONFIG).first()
        eh.verify(bin_series_trie, 'series trie bin not found')
        sync_path = str(sdk2.ResourceData(bin_series_trie).path)
        logging.info('using  %s, res_id %s; sync_path %s', bin_series_trie, bin_series_trie.id, sync_path)
        return sync_path

    def on_execute(self):
        resource = sdk2.ResourceData(resource_types.VideoConfigSeriesNavigatorTrie(
            self, 'Series navigator trie', 'series_navigator.trie'
        ))
        logging.info(resource.path)

        bin_path = self.get_bin_series_trie()

        proc = sp.Popen([bin_path,
            '-t', self.yt_token,
            '-s', self.Parameters.server,
            '-i', self.Parameters.src_table,
            '-o', str(resource.path)])

        proc.wait()
        eh.verify(proc.returncode == 0, 'series navigator config build failed')

        logging.info('success')
