# -*- coding: utf-8 -*-

from sandbox.projects.VideoSearch import video_resource_types as resource_types
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params


class VideoBuildThdbBinaries(BaseMediaBuildTask):
    """
        Бинарники для построения thdb
    """

    type = 'VIDEO_BUILD_THDB_BINARIES'
    execution_space = 80000

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[build_params.StripBinaries.name] = True

    def get_binaries(self):
        return (
            resource_types.VIDEO_BIN_YT_EXECUTABLE,
            resource_types.VIDEO_BIN_THDB,
            resource_types.VIDEO_BIN_VTHDBMRMERGE,
        )

    def get_configs(self):
        return (
            resource_types.VIDEO_CONFIG_VIDSTH_SHARDTOOL,
            resource_types.VIDEO_SCRIPT_VIDSTH_SHARD_BUILDER,
            resource_types.VIDEO_SCRIPT_VIDSTH_THDB_MERGE,
            resource_types.VIDEO_SCRIPT_YT_SH,
        )


__Task__ = VideoBuildThdbBinaries
