# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.VideoSearch import video_resource_types as resource_types

from sandbox.projects.common.BaseVideoBuildBundle import BaseVideoBuildBundle

import sandbox.projects.resource_types.releasers as resource_releasers


class VideoBundleThdb(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers


class VideoBundleThdbUltra(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers


class VideoBuildThdbBundle(BaseVideoBuildBundle):
    """
        Бандл для построения шарда больших имтубов
    """

    __STABLE_SERVICES = ["mr_vidsbase_beta2"]

    def get_built_resources(self):
        return (
            [resource_types.VIDEO_BIN_THDB, 'bin/thdb'],
            [resource_types.VIDEO_BIN_VTHDBMRMERGE, 'bin/vthdbmrmerge'],
            [resource_types.VIDEO_BIN_YT_EXECUTABLE, 'bin/yt'],
            [resource_types.VIDEO_SCRIPT_VIDSTH_THDB_MERGE, 'cm/thdb_merge_yt.sh'],
            [resource_types.VIDEO_SCRIPT_YT_SH, 'cm/yt.sh'],
            [resource_types.VIDEO_SCRIPT_VIDSTH_SHARD_BUILDER, 'shard_builder.sh'],
            [resource_types.VIDEO_CONFIG_VIDSTH_SHARDTOOL, 'config.json'],
        )

    def get_resources(self):
        return ()

    def get_resource_type(self):
        return VideoBundleThdb

    def get_resource_descr(self):
        return 'Main video thumbs deploy bundle'

    def get_resource_file_name(self):
        return 'bundle'

    def get_stable_services(self):
        return self.__STABLE_SERVICES
