# -*- coding: utf-8 -*-


import logging


from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.VideoSearch import video_resource_types as resource_types


class VideoBuildVoiceoverHostsConfig(sdk2.Task):
    """
        Генерация хостов для расклейки озвучек
    """

    class Requirements(sdk2.Requirements):
        environments = (PipEnvironment('yandex-yt'), PipEnvironment('yandex-yt-yson-bindings-skynet'), )

    class Parameters(sdk2.Parameters):
        server = sdk2.parameters.String(
            'YT server',
            default='arnold'
        )

        moonwalk_table = sdk2.parameters.String(
            'Moonwalk hosts path',
            default='//home/videoindex/full/docbase/prevdata/full_index/voiceover_moonwalk'
        )

        hdgo_table = sdk2.parameters.String(
            'Hdgo hosts path',
            default='//home/videoindex/full/docbase/prevdata/full_index/voiceover_hdgo'
        )

    @property
    def yt_token(self):
        return sdk2.Vault.data(self.owner, 'yt_token')

    def on_execute(self):
        resource = sdk2.ResourceData(resource_types.VideoConfigVoiceoverHosts(
            self, 'Voiceover hosts config', 'voiceover_hosts.txt'
        ))

        logging.info(str(resource.path))

        import yt.wrapper as yt
        yt_client = yt.YtClient(proxy=self.Parameters.server, token=self.yt_token)

        data = list(yt_client.read_table(yt.TablePath(self.Parameters.moonwalk_table, end_index=100, columns = ['Host']))) \
                + list(yt_client.read_table(yt.TablePath(self.Parameters.hdgo_table, end_index=100, columns = ['Host'])))

        hosts = set()
        for item in data:
            hosts.add(item['Host'])

        with open(str(resource.path), 'w') as f:
            for item in hosts:
                f.write('%s\n' % item)
