# coding: utf-8

from sandbox import sdk2

from sandbox import common
from sandbox.sandboxsdk.environments import PipEnvironment

import json


class VideoParseStrmVideoContent(sdk2.Task):

    class Requirements(sdk2.Requirements):
        environments = (PipEnvironment('yandex-yt'), PipEnvironment('yandex-yt-yson-bindings-skynet'), )

    class Parameters(sdk2.Parameters):
        dst_table = sdk2.parameters.String('Output table path', required=True)
        server = sdk2.parameters.String('YT server', required=True)

    @property
    def yt_token(self):
        return sdk2.Vault.data(self.owner, 'yt_token')

    def on_execute(self):
        sb_client = common.rest.Client()

        import yt.wrapper as yt
        yt_client = yt.YtClient(proxy=self.Parameters.server, token=self.yt_token)
        yt_client.remove(self.Parameters.dst_table, force=True)
        yt_client.create_table(self.Parameters.dst_table)
        path = yt_client.TablePath(self.Parameters.dst_table, append=True)

        offset = 0
        chunk_size = 1000
        tasks_count = 0
        while True:
            tasks = sb_client.task.read(
                type='STRM_VIDEO_CONVERT',
                status='SUCCESS',
                author='robot-faas-vh',
                offset=offset,
                limit=chunk_size,
            )['items']

            self.set_info('Got items {}-{}'.format(offset, offset + len(tasks)))
            tasks_count += len(tasks)

            rows = []
            for task in tasks:
                output_params = task.get('output_parameters', {})
                stream = json.loads(output_params.get('stream', '{}'))
                duration = stream.get('duration', None)
                if not duration:
                    continue

                rows.append({'task_id': task['id'], 'faas_duration': duration})

            yt_client.write_table(path, rows)

            offset += len(tasks)
            if len(tasks) < chunk_size:
                self.set_info('Number of tasks is {}'.format(tasks_count))
                break
