# -*- coding: utf-8 -*-

import os

from sandbox import sdk2
from sandbox.projects.common.nanny import nanny
from sandbox.projects.VideoSearch import video_resource_types


class VideoReleaseFPSConfig(nanny.ReleaseToNannyTask2, sdk2.Task):

    task = 'VIDEO_RELEASE_FPS_CONFIG'

    resource_file_name = 'processor.conf.tmpl'

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl("FPS Config Arcadia Url")

        config_path = sdk2.parameters.String(
            "Arcadia Path",
            required=True,
            default="extsearch/video/daemons/fresh_profile_server/processor.conf.tmpl"
        )

    def _join_arcadia_paths(self, base_path, target_path):
        joined_path = os.path.join(
            sdk2.svn.Arcadia.parse_url(base_path).path,
            target_path
        )
        return sdk2.svn.Arcadia.replace(base_path, joined_path)

    def on_execute(self):
        resource = video_resource_types.VIDEO_FRESH_PROFILE_SERVER_CONFIG(
            self,
            "video fps config",
            self.resource_file_name
        )
        data = sdk2.ResourceData(resource)

        sdk2.svn.Arcadia.export(
            self._join_arcadia_paths(
                self.Parameters.arcadia_url,
                self.Parameters.config_path
            ),
            data.path
        )

        data.ready()
