import logging


def parse_trie_line(line):
    line = line.strip()
    line_arr = line.split('\t')
    line_arr_len = len(line_arr)

    if line_arr_len == 0:
        raise IndexError
    if line_arr_len != 4:
        logging.error("Expected 4 columns, got {} in trie entry: {}".format(line_arr_len, line))
        return IndexError

    key = line_arr[0]
    value = line_arr[3]
    return key, value
