# -*- coding: utf-8 -*-

import logging
import os
import re

from sandbox import sdk2
from sandbox.sandboxsdk.svn import Arcadia, SvnError


_ARCADIA_USER = "robot-video-recom"
_ROBOT_SSH_PRIVATE_KEY_VAULT_ID = "sec-01f2m3sth0p5507cpjnztx5rgx"


class VideoVideohubCreateConveyorModelsRevision(sdk2.Task):

    task = 'VIDEO_VIDEOHUB_CREATE_CONVEYOR_MODELS_REVISION'

    class Parameters(sdk2.Task.Parameters):

        target_resource_type = sdk2.parameters.String(
            'Target resource type',
            default='OTHER_RESOURCE',
            required=True
        )
        revision = sdk2.parameters.Integer(
            'Revision',
            required=True
        )
        models_dir = sdk2.parameters.String(
            'Models directory',
            required=True
        )
        test_to_prod_path_mapping = sdk2.parameters.Dict(
            'Test to prod path mapping',
            required=True
        )
        startrek_ticket = sdk2.parameters.String(
            'Startrek ticket for commit message'
        )
        skip_check = sdk2.parameters.Bool(
            "Skip precommit checks",
            default=True
        )
        with sdk2.parameters.Output:
            arcadia_commit_url = sdk2.parameters.String(
                "Commit URL",
                default="",
                required=True
            )

    def on_execute(self):
        resource = sdk2.Resource[self.Parameters.target_resource_type](
            self,
            '',
            'revision'
        )
        resource_data = sdk2.ResourceData(resource)
        resource_data.path.write_bytes(str(self.Parameters.revision))
        resource_data.ready()

    def on_release(self, additional_parameters):
        arcadia_url = os.path.join(Arcadia.ARCADIA_TRUNK_URL, self.Parameters.models_dir)
        local_arcadia_dir = Arcadia.checkout(arcadia_url, str(self.path("arcadia")))
        logging.info("Arcadia is checkouted to {}".format(local_arcadia_dir))

        for key, value in self.Parameters.test_to_prod_path_mapping.iteritems():
            local_prod_path = os.path.join(local_arcadia_dir, value)
            remote_test_path = os.path.join(arcadia_url, key)
            Arcadia.export(
                remote_test_path,
                local_prod_path,
                revision=self.Parameters.revision
            )
            logging.info(
                "Exported {} to {} at revision {}".format(
                    remote_test_path,
                    local_prod_path,
                    self.Parameters.revision
                )
            )

        commit_message = "Exported prod models from revision {};".format(self.Parameters.revision)
        if self.Parameters.startrek_ticket is not None:
            commit_message += " " + self.Parameters.startrek_ticket
        if self.Parameters.skip_check:
            commit_message += " SKIP_CHECK"

        try:
            yav_ssh_private_key = sdk2.yav.Secret(_ROBOT_SSH_PRIVATE_KEY_VAULT_ID)

            with sdk2.ssh.Key(private_part=yav_ssh_private_key.data()["rsa_private_key"]):
                result = Arcadia.commit(local_arcadia_dir, commit_message, _ARCADIA_USER)
                logging.info("Commit result: {}".format(result))

                revision = re.findall(r'Committed revision (\d+)\.', result)
                if revision:
                    self.Parameters.arcadia_commit_url = "https://a.yandex-team.ru/arc/commit/" + revision[0]
        except SvnError as e:
            logging.error(e.message)

            review = re.findall(r'https://a\.yandex-team\.ru/review/(\d+)', e.message)
            if not review:
                raise e

            self.Parameters.arcadia_commit_url = "https://a.yandex-team.ru/review/" + review[0]

        logging.info("All done: {}".format(self.Parameters.arcadia_commit_url))

        sdk2.Task.on_release(self, additional_parameters)
