# -*- coding: utf-8 -*-

import os
import shutil
import logging
from sandbox import sdk2
from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.svn import Arcadia
import sandbox.common.types.task as ctt


class VideoVideohubDumpFilesFromArcadia(nanny.ReleaseToNannyTask2, sdk2.Task):

    task = 'VIDEO_VIDEOHUB_DUMP_FILES_FROM_ARCADIA'

    class Parameters(sdk2.Task.Parameters):
        target_resource_type = sdk2.parameters.String(
            'Target resource type',
            default='OTHER_RESOURCE',
            required=True
        )
        arcadia_root_url = sdk2.parameters.String(
            'Arcadia root url',
            required=True
        )
        arcadia_paths = sdk2.parameters.List(
            'Arcadia paths',
            required=True,
        )
        folder_name = sdk2.parameters.String(
            'Folder name',
            required=True,
        )
        version_file = sdk2.parameters.String(
            'Version file name',
            required=False,
        )

    def _join_arcadia_paths(self, base_path, target_path):
        joined_path = os.path.join(
            sdk2.svn.Arcadia.parse_url(base_path).path,
            target_path
        )
        return sdk2.svn.Arcadia.replace(base_path, joined_path)

    def on_execute(self):
        resource = sdk2.Resource[self.Parameters.target_resource_type](
            self, '', self.Parameters.folder_name)
        resource_data = sdk2.ResourceData(resource)
        self.resource_directory = str(resource_data.path)
        os.mkdir(self.resource_directory)

        for path in self.Parameters.arcadia_paths:
            _, file_name = path.rstrip('/').rsplit('/', 1)
            path = self._join_arcadia_paths(self.Parameters.arcadia_root_url, path)
            Arcadia.export(path, os.path.join(self.resource_directory, file_name))

        if self.Parameters.version_file:
            with open(os.path.join(self.resource_directory, self.Parameters.version_file), 'w+') as f:
                f.write(Arcadia.get_revision(self.Parameters.arcadia_root_url))

        resource_data.ready()
