# coding: utf-8

from sandbox.sdk2.resource import AbstractResource
from sandbox.projects.resource_types import releasers as resource_releasers

from sandbox import sdk2


class VideoBundleDocbase(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers


class VideoIndexPqBundle(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers


class VideoWebscriptsResource(sdk2.Resource):
    """ Tar file with video webscripts """
    releasable = True
    executable = False
    releasers = resource_releasers.video_robot_releasers
    ttl = "inf"


class VideoWebscriptsRawResource(sdk2.Resource):
    """ Video webscripts """
    releasable = True
    executable = False
    releasers = resource_releasers.video_robot_releasers
    ttl = "inf"


class VIDEO_BUNDLE(AbstractResource):
    """
       Базовый класс бандла для видео
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.video_robot_releasers
    release_subscribers = resource_releasers.video_robot_releasers + ['video-monitoring']


class VideoIndexLocalShard(sdk2.Resource):
    releasable = False
    executable = False
    ttl = "inf"


class VideoBundleIndex(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers


class VideoConfigDocbase(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers


class VideoMMetaShardConfig(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers


class VideoCanonizeConfig(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers


class VIDEO_MIDDLESEARCH_VIDEOHUB_TRIE_PLAIN(AbstractResource):
    releasable = True
    releasers = resource_releasers.base_releasers + resource_releasers.video
    auto_backup = True
    any_arch = True
    basename = 'videohub.trie.lst'


class VIDEO_MIDDLESEARCH_VIDEOHUB_TRIE(AbstractResource):
    releasable = True
    releasers = resource_releasers.base_releasers + resource_releasers.video
    auto_backup = True
    any_arch = True
    basename = 'videohub.trie'


class VIDEO_BIN_VINDEXBUILDER(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/robot/index/indexbuilder/vindexbuilder'


class VIDEO_BIN_DG_OXYGEN(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/oxygen/dg_oxygen/dg_oxygen"


class VIDEO_BIN_DOCEXPORT(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/docexport/docexport"


class VIDEO_BIN_DOCFACTOR(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/docfactor/docfactor"


class VIDEO_BIN_DOCMERGE(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/docmerge/docmerge"


class VIDEO_BIN_FACTORS2(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/factors2/factors2"


class VIDEO_BIN_INCPLANNER(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/incplanner/incplanner"


class VIDEO_BIN_INDEXANN_VIDEO_HELPER(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/quality/indexann/helper/indexann_video_helper"


class VIDEO_BIN_INDEXDOCS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/indexdocs/indexdocs"


class VIDEO_BIN_DSSM_CALC(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/dssm_calc/dssm_calc"


class VIDEO_BIN_PQ2SAAS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/index/pq2saas/pq2saas"


class VIDEO_BIN_PQINDEXER(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/index/pqindexer/pqindexer"


class VIDEO_BIN_PQ_REINDEX(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/index/pq_reindex/pq_reindex"


class VIDEO_BIN_DIFF_KEYS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/tools/yt/diff_keys/diff_keys"


class VIDEO_BIN_MERGEOBJECTS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/mergeobjects/mergeobjects"


class VIDEO_BIN_EXTRACT_HOSTOWNERS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/extract_hostowners/extract_hostowners"


class VIDEO_BIN_THUMBS_CONSUMER(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/thumbs_consumer/thumbs_consumer"


class VIDEO_BIN_PRECALC_PQ(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/precalc_pq/precalc_pq"


class VIDEO_BIN_SNIPPETS2SAAS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/snippets_calc/snippets2saas/snippets2saas"


class VIDEO_BIN_INDEXEXPORT(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/index/indexexport/indexexport"


class VIDEO_BIN_INDEXFACTORS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/index/indexfactors/indexfactors"


class VIDEO_BIN_REMOTE_STORAGE_INDEX(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/index/remote_storage_index/remote_storage_index"


class VIDEO_BIN_DOCSELRANK(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/docselrank/docselrank"


class VIDEO_BIN_INDEX_TOOLS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/index_tools/index_tools"


class VIDEO_BIN_JOIN_OXYGEN(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/oxygen/join_oxygen/join_oxygen"


class VIDEO_BIN_PRECALC(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/precalc/precalc"


class VIDEO_BIN_REMAPKIWI(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/remapkiwi/remapkiwi"


class VIDEO_BIN_SEND_HISTORY(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/oxygen/send_history/send_history"


class VIDEO_BIN_VDUPMR(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/video/mr_scripts/vdupmr/vdupmr"


class VIDEO_BIN_YT_TOOLS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/tools/yt/yt_tools/yt_tools"


class VIDEO_BIN_YAMR_DYNAMIZE(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/tools/yt/yamr_dynamize/yamr_dynamize"


class VIDEO_BIN_YT_DYNAMIZE(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/tools/yt/yt_dynamize/yt_dynamize"


class VIDEO_BIN_EXPAND_SRCURLS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/expand_srcurls/expand_srcurls"


class VIDEO_BIN_URLFEXPORT(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/factors/urlfexport/urlfexport"


class VIDEO_BIN_AUTHFEXPORT(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/factors/authfexport/authfexport"


class VIDEO_BIN_HOSTFEXPORT(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/factors/hostfexport/hostfexport"


class VIDEO_BIN_ADAPTOR(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/vegas/adaptor/adaptor"


class VIDEO_BIN_VUSERDATA_OXYGEN(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/oxygen/vuserdata_oxygen/vuserdata_oxygen"


class VIDEO_BIN_YT_EXECUTABLE(VIDEO_BUNDLE):
    arcadia_build_path = "yt/python/yt/wrapper/bin/yt_make/yt"


class VIDEO_BIN_THDB(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/images/robot/tools/thdb/thdb"


class VIDEO_BIN_VTHDBMRMERGE(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/video/mr_scripts/vthdbmrmerge/vthdbmrmerge"


class VIDEO_BIN_VEGAS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/quality/vegas/vegas"


class VIDEO_BIN_MR_SET_OPS_RWS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/tools/mr/mr_set_ops_rws/mr_set_ops_rws"


class VIDEO_BIN_RESTORE_SEND_HISTORY(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/oxygen/tools/restore_send_history/restore_send_history"


class VIDEO_BIN_STATFACTORS_FILTER(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/tools/statfactors_filter/statfactors_filter"


class VIDEO_BIN_PREBUILD(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/prebuild/prebuild"


class VIDEO_BIN_RELDUPMR(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/video/mediadb/reldupmr/reldupmr"


class VIDEO_BIN_MEDIAEXPORT(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/video/mediadb/mediaexport/mediaexport"


class VIDEO_BIN_THUMBFEXPORT(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/factors/thumbfexport/thumbfexport"


class VIDEO_BIN_ANNFEXPORT(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/factors/annfexport/annfexport"


class VIDEO_BIN_PREPARE_VIDEOBAN(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/quality/vegas/tools/prepare_videoban/prepare_videoban"


class VIDEO_BIN_XFACTOR_YT(VIDEO_BUNDLE):
    arcadia_build_path = "quality/relev_tools/xfactor-yt/bin/xfactor-yt"


class VIDEO_BIN_ANCHORBASE(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/crawling/anchorbase/anchorbase"


class VIDEO_BIN_EXTRACT_TS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/extract_ts/extract_ts"


class VIDEO_BIN_SPOK_AGGREGATE(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/spok_aggregate/spok_aggregate"


class VIDEO_BIN_DUPSMERGE(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/dups/dupsmerge/dupsmerge"


class VIDEO_BIN_GCFACTOR(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/tools/gcfactor/gcfactor"


class VIDEO_BIN_SANDBOX_RESOURCE_DOWNLOADER(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/webscripts/video/common/sandbox/sandbox_resource_downloader"


class VIDEO_BIN_SBR_CALC(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/sbr_metric/sbr_calc/sbr_calc"


class VIDEO_BIN_SBR_TOOL(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/sbr_metric/sbr_tool/sbr_tool"


class VIDEO_BIN_STORYLOG(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/sepe/ydl/storylog"


class VIDEO_BIN_DOCOBJECT(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/docobject/docobject"


class VIDEO_BIN_POSTCALC(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/postcalc/postcalc"


class VIDEO_BIN_ROBOTMETRICS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/metrics/robotmetrics"


class VIDEO_BIN_PORNO3(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/webutil/porno3/porno3"


class VIDEO_BIN_URL2HOST(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/video/tools/url2host/url2host"


class VIDEO_BIN_GRATTRVIEW(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/robot/tools/grattrview/grattrview"


class VIDEO_BIN_USERDATA_INDEX(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/userdata_index/userdata_index"


class VIDEO_BIN_ADD_SPOK(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/tools/add_spok/add_spok"


class VIDEO_BIN_FUSIONEXPORT(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/metrics/fusionexport/fusionexport"


class VIDEO_BIN_DOCUPDATES(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/metrics/docupdates/docupdates"


class VIDEO_BIN_CUMSUM(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/metrics/cumsum/cumsum"


class VIDEO_BIN_PLAYER_COVERAGE(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/selrank/player_coverage/player_coverage"


class VIDEO_BIN_GRATTRGEN(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/webutil/grattrgen/grattrgen"


class VIDEO_BIN_VDATAWORK(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/video/tools/vdatawork/vdatawork"


class VIDEO_BIN_WRITE_SENTENCE_LENGTHS(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/robot/write_sentence_lengths/write_sentence_lengths"


class VIDEO_BIN_VHAMMER(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/hammer/vhammer"


class VIDEO_BIN_RS_INDEX_BUILDER(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/remote_storage/index_builder/rs_index_builder"


class VIDEO_BIN_USERDATA_DL(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/userdata_dl/userdata_dl"


class VIDEO_BIN_USERDATA_MANIP(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/robot/userdata/userdata_manip/userdata_manip"


class VIDEO_BIN_FLAGS_EXPORT(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/snippets_calc/flags_export/flags_export"


class VIDEO_BIN_FILTER_SNIPPETS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/snippets_calc/filter_snippets/filter_snippets"


class VIDEO_BIN_PRINTKEYS(VIDEO_BUNDLE):
    arcadia_build_path = "tools/printkeys/printkeys"


class VIDEO_BIN_TARCVIEW(VIDEO_BUNDLE):
    arcadia_build_path = "tools/tarcview/tarcview"


class VIDEO_BIN_SHARD_TOOL(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/images/robot/shard_tool/shard_tool"


class VIDEO_BIN_CLUSTER_STATE(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/images/robot/cluster_state/cluster_state"


class VIDEO_BIN_VTRIEBUILDER(VIDEO_BUNDLE):
    arcadia_build_path = "yweb/video/index/vtriebuilder/vtriebuilder"


class VIDEO_CONFIG_CLATTRGEN(VIDEO_BUNDLE):
    arcadia_path = "yweb/webscripts/video/index/config/clattrgen.cfg"
    executable = False


class VIDEO_CONFIG_QUERYREC_DICT(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_QUERYREC_FILTERS(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_QUERYREC_WEIGHTS(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_GEOA_C2P(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_SEO_QUERY(VIDEO_BUNDLE):
    arcadia_path = "yweb/pornofilter/seo.query"
    executable = False


class VIDEO_SCRIPT_INDEX_SH(VIDEO_BUNDLE):
    arcadia_path = "yweb/webscripts/video/cm/common/index_yt.sh"
    executable = False


class VIDEO_CONFIG_INDEX_SHARD_TOOL(VIDEO_BUNDLE):
    arcadia_path = "yweb/webscripts/video/index/shardtool_config.json"
    executable = False


class VIDEO_SCRIPT_INDEX_SHARD_BUILDER(VIDEO_BUNDLE):
    arcadia_path = "yweb/webscripts/video/index/shard_builder.sh"


class VIDEO_SCRIPT_INDEX_SHARD_BUILDER_JUPITER(VIDEO_BUNDLE):
    arcadia_path = "yweb/webscripts/video/index/shard_builder_jupiter.sh"


class VIDEO_SCRIPT_INDEX_SHARD_UNINSTALL(VIDEO_BUNDLE):
    arcadia_path = "extsearch/images/robot/index/scripts/index-download/shard-uninstall.sh"


class VIDEO_CONFIG_VIDSTH_SHARDTOOL(VIDEO_BUNDLE):
    arcadia_path = "yweb/webscripts/video/thumbnails/shardtool_config.json"
    executable = False


class VIDEO_SCRIPT_VIDSTH_SHARD_BUILDER(VIDEO_BUNDLE):
    arcadia_path = "yweb/webscripts/video/thumbnails/shard_builder.sh"


class VIDEO_SCRIPT_VIDSTH_THDB_MERGE(VIDEO_BUNDLE):
    arcadia_path = "yweb/webscripts/video/cm/common/thdb_merge_yt.sh"


class VIDEO_SCRIPT_YT_SH(VIDEO_BUNDLE):
    arcadia_path = "yweb/webscripts/video/cm/common/yt.sh"


class VIDEO_BIN_DOCDUMP(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/docdump/docdump"


class VIDEO_BIN_PREPARE_DOCIDS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/index/prepare_docids/prepare_docids"


class VIDEO_BIN_INDEX_SEARCHABLE(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/index/index_searchable/index_searchable"


class VIDEO_BIN_KEYPOINTS_CONVERT(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/index/keypoints_convert/keypoints_convert"


class MR_OBJECTS_EXTRACTOR(VIDEO_BUNDLE):
    arcadia_build_path = "dict/tools/ner/mrobjectsextractor/mrobjectsextractor"


class VIDEO_BIN_WRANGLER(VIDEO_BUNDLE):
    arcadia_build_path = "search/panther/tools/wrangler/wrangler"


class VIDEO_CONFIG_VEGAS(VIDEO_BUNDLE):
    executable = False


class VIDEO_ZORADNSBAN_TRIE(VIDEO_BUNDLE):
    executable = False


class VIDEO_DOCUMENT_PLATFORMS_CFG(VIDEO_BUNDLE):
    executable = False


class VIDEO_INDEX_DEPLOY_DASHBOARD_CONFIG(VIDEO_BUNDLE):
    executable = False
    arcadia_path = 'extsearch/video/robot/index/deploy_dashboard/config.json'


class VIDEO_TEST_SHARDMAP(VIDEO_BUNDLE):
    executable = False
    shardmap = True


class VIDEO_BASESEARCH_EXECUTABLE_FUZZY(AbstractResource):
    """
        Исполняемый файл базового видеопоиска с фаззером (SEARCH-5194)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.base_releasers + resource_releasers.video
    arcadia_build_path = 'extsearch/video/base/fuzzing/fuzzing'
    arcadia_build_name = 'video_basesearch_fuzzy'


class VIDEO_VITRINA_BASESEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл базового видеопоиска для Витрины
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.base_releasers + resource_releasers.video
    arcadia_build_path = 'extsearch/video/vitrina/base/daemon/vitrina_basesearch'
    arcadia_build_name = 'vitrina_basesearch'


class VIDEO_VITRINA_BASESEARCH_INDEX(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.video


class VIDEO_VITRINA_BASESEARCH_CONFIG(sdk2.Resource):
    arcadia_build_path = "extsearch/video/vitrina/base/daemon/config/vitrina_base.cfg"
    auto_backup = True
    releasable = True
    releasers = resource_releasers.video


class VIDEO_VITRINA_METASEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл среднего видеопоиска для Витрины
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.base_releasers + resource_releasers.video
    arcadia_build_path = 'extsearch/video/vitrina_meta/daemon/vitrina_metasearch'
    arcadia_build_name = 'vitrina_metasearch'


class VIDEO_MIDDLESEARCH_VH_DUPS_TRIE(AbstractResource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers
    auto_backup = True
    any_arch = True
    basename = 'vh_dups.trie'


class VIDEO_MIDDLESEARCH_VH_ATTRS_TRIE(AbstractResource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers
    auto_backup = True
    any_arch = True
    basename = 'vh_attrs.trie'


class VIDEO_MIDDLESEARCH_VH_DUPS_RAW(AbstractResource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers
    auto_backup = True
    any_arch = True
    basename = 'vh_dups.raw'


class VIDEO_MIDDLESEARCH_VH_ATTRS_RAW(AbstractResource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers
    auto_backup = True
    any_arch = True
    basename = 'vh_attrs.raw'


class VIDEO_BIN_DOCAUTHOR(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/docauthor/docauthor"


class VIDEO_BIN_AVA_URL_EXTRACTOR(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/ava_url_extractor/ava_url_extractor"


class VIDEO_CONFIG_KIDS_CHANNELS(VIDEO_BUNDLE):
    executable = False


class VideoConfigSeriesNavigatorTrie(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers


class VideoConfigVoiceoverHosts(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.video_robot_releasers


class VIDEO_CONFIG_DATES_EXTRACTOR(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_VOICEOVERSTUDIO_REGEXP(VIDEO_BUNDLE):
    executable = False


class VIDEO_BIN_SERIES_TRIE_CONFIG(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/robot/docbase/library/series_navigator/series_trie_config/series_trie_config"


class VIDEO_CONFIG_KIDS_STOPWORDS(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_VOICEOVERSTUDIO_WHITELIST(VIDEO_BUNDLE):
    executable = False


class VIDEO_BIN_VHS_STATIC_FACTORS(VIDEO_BUNDLE):
    arcadia_build_path = "extsearch/video/tools/vhs_static_factors/vhs_static_factors"


class VIDEO_CONFIG_WIDE_QUERY_GENRE_AND_LINKS(VIDEO_BUNDLE):
    executable = False
    releasers = resource_releasers.video_data


class VIDEO_CONFIG_WIDE_QUERY_GENRE_PARENT_LINKS(VIDEO_BUNDLE):
    executable = False
    releasers = resource_releasers.video_data


class VIDEO_CONFIG_WIDE_QUERY_GENRE_INDEX(VIDEO_BUNDLE):
    executable = False
    releasers = resource_releasers.video_data


class VIDEO_CONFIG_WIDE_QUERY_COUNTRY_INDEX(VIDEO_BUNDLE):
    executable = False
    releasers = resource_releasers.video_data


class VIDEO_CONFIG_TOLOKA_DSSM(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_INDEX_KNN_CKMEANS(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_KNN_FPS_DSSM(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_KNN_FPS_CKMEANS(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_CATEG_DSSM(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_CATEG_VIEWS(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_CATEG_PARENT_LINKS(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_PERSONAL_MODEL(VIDEO_BUNDLE):
    executable = False


class VIDEO_UNITY_DSSM_BUNDLE(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_ADV_TAGS(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_ADV_CATEGS(VIDEO_BUNDLE):
    executable = False


class VIDEO_CONFIG_ADV_BS_TAGS(VIDEO_BUNDLE):
    executable = False


class VIDEO_CATEGS_BY_KINOPOISK_ID(VIDEO_BUNDLE):
    executable = False


class VIDEO_BS_CATEGS_BY_KINOPOISK_ID(VIDEO_CATEGS_BY_KINOPOISK_ID):
    executable = False


class VIDEO_BS_FORBIDDEN_CATEGS_FOR_KINOPOISK_CONTENT(VIDEO_BUNDLE):
    executable = False


class VIDEO_CATEGS_BY_CONTENT_ID(VIDEO_BUNDLE):
    executable = False


class VIDEO_CATEGS_BY_AUTHOR_ID(VIDEO_BUNDLE):
    executable = False


class VIDEO_CATEGS_BY_CHANNEL_ID(VIDEO_BUNDLE):
    executable = False


class VIDEO_BS_CATEGS_BY_CONTENT_ID(VIDEO_BUNDLE):
    executable = False


class VIDEO_BS_CATEGS_BY_AUTHOR_ID(VIDEO_BUNDLE):
    executable = False


class VIDEO_BS_CATEGS_BY_CHANNEL_ID(VIDEO_BUNDLE):
    executable = False


class VIDEO_BS_CATEGS_BY_HOST(VIDEO_BUNDLE):
    executable = False


class VIDEO_SUPERTAGS(VIDEO_BUNDLE):
    executable = False
    basename = 'videohub_supertags'


class VIDEO_CATEG_SIMILARITIES(VIDEO_BUNDLE):
    executable = False


class VIDEO_CATEG_INFO_STORAGE(VIDEO_BUNDLE):
    executable = False
    basename = 'categ_info_storage'


class VIDEO_MIDDLE_RECOMMENDER_CONFIG(VIDEO_BUNDLE):
    executable = False
    basename = 'dj_middle_recommender'


class VIDEO_MIDDLE_RECOMMENDER_MODELS(VIDEO_BUNDLE):
    executable = False
    basename = 'dj_middle_models.tar'


class VIDEO_PROFILE(VIDEO_BUNDLE):
    executable = False


class VIDEO_CATEG_RECOMMENDER_SHARD(VIDEO_BUNDLE):
    executable = False


class VIDEO_CATEG_RECOMMENDER_SHARDMAP(VIDEO_BUNDLE):
    executable = False


class VIDEO_DOC_RECOMMENDER_SHARD(VIDEO_BUNDLE):
    executable = False


class VIDEO_DOC_RECOMMENDER_SHARDMAP(VIDEO_BUNDLE):
    executable = False


class VIDEO_DOC2DOC_RECOMMENDER_SHARD(VIDEO_BUNDLE):
    executable = False


class VIDEO_DOC2DOC_RECOMMENDER_SHARDMAP(VIDEO_BUNDLE):
    executable = False


class VIDEO_VIDEOHUB_DJ_CONFIG_BUNDLE(VIDEO_BUNDLE):
    executable = False
    ttl = "inf"
    releasers = resource_releasers.vh_recommender_releasers
    release_subscribers = resource_releasers.vh_recommender_releasers


class VIDEO_VIDEOHUB_DJ_CONFIG_BUNDLE_OFFLINE(VIDEO_BUNDLE):
    executable = False


class VIDEO_VIDEOHUB_STATIC_CONFIG_BUNDLE(VIDEO_BUNDLE):
    executable = False


class VIDEO_MIDDLESEARCH_VIDEOFASTDELIVERY_URLS(AbstractResource):
    """
        Файл с документами для быстрой доставки
    """
    releasable = True
    releasers = resource_releasers.video_data
    release_subscribers = ['video-monitoring']
    auto_backup = True
    any_arch = True
    basename = 'videofastdelivery.plain'


class VIDEO_MIDDLESEARCH_VIDEOFASTDELIVERY_TRIE(AbstractResource):
    """
        Файл с документами для быстрой доставки
    """
    releasable = True
    releasers = resource_releasers.video_data
    release_subscribers = ['video-monitoring']
    auto_backup = True
    any_arch = True
    basename = 'videofastdelivery.trie'
    plain_resource_type = VIDEO_MIDDLESEARCH_VIDEOFASTDELIVERY_URLS


class VIDEO_HUBTAG_RESTRICTIONS(AbstractResource):
    releasable = True
    releasers = resource_releasers.video_data
    auto_backup = True
    any_arch = True
    basename = 'hub_doc2doc_restrictions.json'


class VIDEO_BIN_YT_RULE_APPLIER(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/quality/recommender/tools/yt_rule_applier'


class VIDEO_BIN_COUNTER_FEATURE_DUMPER(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/quality/recommender/tools/counter_feature_dumper'


class VIDEO_BIN_BUILD_CATEGS(VIDEO_BUNDLE):
    arcadia_build_path = 'vh/recommender/tools/build_categs'


class VIDEO_BIN_RANKING_TAGS(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/quality/recommender/tools/ranking_tags'


class VIDEO_LIB_DJ_UDF(VIDEO_BUNDLE):
    arcadia_build_path = 'yql/udfs/dj/dj_module'


class VIDEO_LIB_VIDEO_PROFILE_UDF(VIDEO_BUNDLE):
    arcadia_build_path = 'yql/udfs/video/profile'


class VIDEO_BIN_MODEL_BUSINESS_STATS(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/quality/recommender/tools/model_business_stats'


class VIDEO_BIN_DJ_BUILD_TRIE(VIDEO_BUNDLE):
    arcadia_build_path = 'dj/tools/build_trie'


class VIDEO_BIN_DJ_OFFLINE_RECOMMENDER(VIDEO_BUNDLE):
    arcadia_build_path = 'dj/tools/offline_recommender'


class VIDEO_BIN_BUILD_POOL(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/quality/recommender/tools/build_pool'


class VIDEO_BIN_PROCESS_POOL(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/quality/recommender/tools/process_pool'


class VIDEO_BIN_DJ_BUILD_POOL(VIDEO_BUNDLE):
    arcadia_build_path = 'dj/tools/train/pool/build_pool'


class VIDEO_BIN_DJ_PROCESS_POOL(VIDEO_BUNDLE):
    arcadia_build_path = 'dj/tools/train/pool/process_pool'


class VIDEO_BUILD_OFFLINE_PERSONAL_RECOMMENDATIONS(VIDEO_BUNDLE):
    arcadia_build_path = 'vh/recommender/tools/build_offline_recommendations'


class VIDEO_BUILD_OFFLINE_DOC2DOC_RECOMMENDATIONS(VIDEO_BUNDLE):
    arcadia_build_path = 'vh/recommender/tools/build_offline_doc2doc'


class VIDEO_BUILD_DOC_PROFILE_TOOL(VIDEO_BUNDLE):
    arcadia_build_path = 'vh/recommender/tools/dssm_profiles'


class VIDEO_BIN_YT_USER_ACTIONS(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/kernel/profile/tools/yt_user_actions'


class VIDEO_BIN_UPLOAD_TO_KVSAAS(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/quality/recommender/1492/scripts/upload_ns'


class VIDEO_BIN_PROMO_INDEXER(VIDEO_BUNDLE):
    arcadia_build_path = 'vh/recommender/tools/services_promo_indexer/promo_indexer'


class VIDEO_BIN_PROMO_CONFIG_INDEXER(VIDEO_BUNDLE):
    arcadia_build_path = 'vh/recommender/tools/services_promo_indexer/config_indexer'


class VIDEO_BIN_VH_APPHOST_LOGS(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/kernel/profile/tools/custom/vh_apphost_logs'


class VIDEO_BIN_YT_TRANSFER_TOOL(VIDEO_BUNDLE):
    arcadia_build_path = 'vh/recommender/tools/yt_transfer'


class VIDEO_BIN_DELAYED_VIEW_STATS(VIDEO_BUNDLE):
    arcadia_build_path = 'vh/recommender/tools/delayed_view_stats'


class VIDEO_BIN_GET_LOWERBOUND_DATE(VIDEO_BUNDLE):
    arcadia_build_path = 'vh/recommender/tools/get_lowerbound_date_for_timestamp'


class VIDEO_VH_TAG_DATA(VIDEO_BUNDLE):
    executable = False


class VIDEO_VH_TOP_CONTENT_AUTHORS(VIDEO_BUNDLE):
    executable = False


class VIDEO_VH_LAUNCHER_CONVEYOR_TEST_MODELS_REVISION(VIDEO_BUNDLE):
    executable = False
    releasers = resource_releasers.vh_recommender_releasers
    release_subscribers = resource_releasers.vh_recommender_releasers


class VIDEO_BIN_ENTITY_AUXILIARY_SHARD(VIDEO_BUNDLE):
    executable = False
    releasers = resource_releasers.vh_recommender_releasers
    release_subscribers = resource_releasers.vh_recommender_releasers


class VIDEO_BIN_SHARD_MODELS(VIDEO_BUNDLE):
    executable = False
    releasers = resource_releasers.vh_recommender_releasers
    release_subscribers = resource_releasers.vh_recommender_releasers


class VIDEO_BIN_ENTITY_CONVEYOR_TEST_MODELS_REVISION(VIDEO_BUNDLE):
    executable = False
    releasers = resource_releasers.vh_recommender_releasers
    release_subscribers = resource_releasers.vh_recommender_releasers


class VIDEO_BIN_ENTITY_MODELS(VIDEO_BUNDLE):
    executable = False
    releasers = resource_releasers.vh_recommender_releasers + resource_releasers.entitysearch_releasers
    release_subscribers = resource_releasers.vh_recommender_releasers + resource_releasers.entitysearch_releasers


class VIDEO_BIN_KP_PROMO_INDEXER(VIDEO_BUNDLE):
    arcadia_build_path = 'vh/recommender/tools/kp_promo_indexer'


class VIDEO_KP_INDEXER_CONFIG(VIDEO_BUNDLE):
    executable = False
    arcadia_path = 'vh/recommender/tools/kp_promo_indexer/config.json'


class VIDEO_BIN_QUOTA_CLEANER(VIDEO_BUNDLE):
    arcadia_path = 'vh/recommender/tools/quota_cleaner'


class VIDEO_BIN_USER_SESSIONS_PARSER(VIDEO_BUNDLE):
    arcadia_build_path = 'vh/recommender/tools/user_sessions_parser'


class VIDEO_BIN_VOICE_LOG_PARSER(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/kernel/profile/tools/custom/voice_logs'


class VIDEO_BIN_FRESH_PROFILE_SERVER(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/daemons/fresh_profile_server'
    executable = True
    releasers = resource_releasers.vh_recommender_releasers
    release_subscribers = resource_releasers.vh_recommender_releasers


class VIDEO_BIN_DOC2DOC_ACTION_PARSER(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/quality/doc2doc/action_parser'
    executable = True
    releasers = resource_releasers.vh_recommender_releasers
    release_subscribers = resource_releasers.vh_recommender_releasers


class VIDEO_FRESH_PROFILE_SERVER_CONFIG(VIDEO_BUNDLE):
    arcadia_path = 'extsearch/video/daemons/fresh_profile_server/processor.conf.tmpl'
    executable = False
    releasers = resource_releasers.vh_recommender_releasers
    release_subscribers = resource_releasers.vh_recommender_releasers


class VIDEO_FRESH_PROFILE_SERVER_METADATA_SHARD(VIDEO_BUNDLE):
    executable = False
    releasers = resource_releasers.vh_recommender_releasers
    release_subscribers = [
        'tkachenkod',
    ]


class VIDEO_L1_DYNAMIC_MODELS_ARCHIVE(sdk2.Resource):
    """
        Dynamic models for video l1 intsearch
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = resource_releasers.video


class VIDEO_L1_INTSEARCH_EXECUTABLE(sdk2.Resource):
    """
        Video l1 intsearch binary
    """
    executable = True
    auto_backup = True
    any_arch = False
    releasable = True
    releasers = resource_releasers.video
    arcadia_build_path = 'search/daemons/l1_intsearch/l1_intsearch'


class VIDEO_EMBEDDING_STORAGE_EXECUTABLE(sdk2.Resource):
    """
        Video embedding storage binary
    """
    executable = True
    auto_backup = True
    any_arch = False
    releasable = True
    releasers = resource_releasers.video
    arcadia_build_path = 'search/base_search/daemons/embedding_storage/embedding_storage'


class VIDEO_INVERTED_INDEX_EXECUTABLE(sdk2.Resource):
    """
        Video inverted index binary
    """
    executable = True
    auto_backup = True
    any_arch = False
    releasable = True
    releasers = resource_releasers.video
    arcadia_build_path = 'search/base_search/daemons/inverted_index_storage/inverted_index_storage'


class VIDEO_BIN_GET_PREMIUM(VIDEO_BUNDLE):
    arcadia_path = 'extsearch/video/quality/recommender/tools/quota/get_premium'


class VIDEO_BIN_EXTRACT_SIG_URLS(VIDEO_BUNDLE):
    arcadia_build_path = 'extsearch/video/robot/docbase/extract_sig_urls/extract_sig_urls'


class VIDEO_DEEP_SEARCH_KNN_INDEX(VIDEO_BUNDLE):
    executable = False


class VIDEO_MODELS_HUB_EXECUTABLE(sdk2.Resource):
    """
        Video ModelsHub Executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.video
    arcadia_build_path = 'extsearch/video/search/models_hub/models_hub'


class VIDEO_MODELS_HUB_DYNAMIC_MODELS_ARCHIVE(sdk2.Resource):
    """
        Dynamic models for video models_hub
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = resource_releasers.video


class CATEG_MARKUP_BRAND_SAFETY_WEB_BUNDLE(VIDEO_BUNDLE):
    executable = False


class CATEG_MARKUP_ADV_CATEGS_WEB_BUNDLE(VIDEO_BUNDLE):
    executable = False


class ZEN_CATEG_GIF_BUNDLE(VIDEO_BUNDLE):
    executable = False


class ZEN_CATEG_NATIVE_BUNDLE(VIDEO_BUNDLE):
    executable = False


class VideoQproxyBundle(sdk2.Resource):
    releasable = True


class VIDEO_MIDDLE_INDEX(sdk2.Resource):
    """
        Index for middlesearch
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = resource_releasers.video_data
