# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.errors import SandboxTaskFailureError

from sandbox.projects import resource_types

from sandbox.projects.common.BaseGetShardmapTask import ShardmapSvnUrlParameter
from sandbox.projects.common.DeployMediaShardmap import DeployMediaShardmap
from sandbox.projects.common.utils import check_subtasks_fails

from sandbox.projects.DeployNannyShardmap import NannyServiceNameParameter

from sandbox.projects.common.DeployMediaShardmap import NannyThumbServiceNameParameter
from sandbox.projects.common.DeployMediaShardmap import ImportedShardmapResourceParameter

from sandbox.projects import GetMediaShardmapFromSvnTask
from sandbox.projects.common.nanny import nanny


class VideoShardmapBaseUltraBySvn(DeployMediaShardmap):
    """
        Отслеживаем новый шардмап в svn директории и деплоим его в сервис.
        После успешного завершения даём ссылку на релиз шардмапа для выкатки
        его в продакшен.
    """

    type = 'VIDEO_SHARDMAP_BASE_ULTRA_BY_SVN'

    input_parameters = [
        ShardmapSvnUrlParameter,
        NannyServiceNameParameter,
        NannyThumbServiceNameParameter,
        ImportedShardmapResourceParameter,
    ]

    def _get_shardmap_resource_type(self):
        return resource_types.VIDEO_ULTRA_BASE_SHARDMAP

    def _get_shardmap_task_type(self):
        return GetMediaShardmapFromSvnTask.GetMediaShardmapFromSvnTask.type

    def on_execute(self):
        # get oauth token
        nanny_client = nanny.NannyClient(
            api_url='http://nanny.yandex-team.ru/',
            oauth_token=self.get_vault_data('MEDIA_DEPLOY', 'nanny-oauth-token'),
        )

        # wait subtasks if exists
        subtasks = channel.sandbox.list_tasks(parent_id=self.id)
        tasks_to_wait = filter(lambda x: not x.is_done(), subtasks)
        if tasks_to_wait:
            check_subtasks_fails(fail_on_first_failure=True)

        # get production timestamp for thumbnails
        self.ctx[u'thumb_timestamp'] = self._get_thumbs_shardmap(nanny_client)
        if self.ctx['thumb_timestamp'] is None:
            raise SandboxTaskFailureError("I couldn't find production timestamp from thumbnails. Stop executing.")

        if 'production_timestamp' not in self.ctx and self.ctx[NannyServiceNameParameter.name] != "":
            self.ctx['production_timestamp'] = self._get_production_timestamp(nanny_client)

        if 'raw_resource_id' not in self.ctx:
            if self.ctx[NannyServiceNameParameter.name] == "":
                self.ctx['raw_resource_id'] = self._get_deployment_shardmap_by_svn()
            else:
                shardmap_from_sandbox = self._get_deployment_shardmap_by_sandbox(self.ctx['production_timestamp'])
                if shardmap_from_sandbox:
                    self.ctx['raw_resource_id'] = shardmap_from_sandbox
                else:
                    # get shardmap to deploy from svn
                    self.ctx['raw_resource_id'] = self._get_deployment_shardmap_by_svn()

        if self.ctx['raw_resource_id'] is not None:
            if self._compare_timestamps() and int(self.ctx['deployment_timestamp']) < int(self.ctx[u'thumb_timestamp']):
                shardmap_resource = channel.sandbox.get_resource(self.ctx['raw_resource_id'])
                self.create_release(shardmap_resource.task_id, status='stable', subject='%s' % (self.ctx['deployment_shardmapname']))


__Task__ = VideoShardmapBaseUltraBySvn
