# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import SandboxStringParameter

from sandbox.projects.MediaLib.MediaStoreShardmap import (
    MediaStoreShardmap, ShardmapType, SwitchDashboardName,
    IndexState, NewDBDashboardName, RollbackActivateRecipe, SwitchDashboardGroups
)


SWITCH_DASHBOARD_NAME = 'video_base'
SWITCH_DASHBOARD_GROUPS = 'prod,hamster'
NEWDB_DASHBOARD_NAME = 'video_newdb'
ROLLBACK_ACTIVE_RECIPE = 'default'


class PrimaryShardsCount(SandboxStringParameter):
    name = 'primary_shards_count'
    description = 'Primary shards count'
    required = False
    default_value = '252'


class ThumbDBGeneration(SandboxStringParameter):
    name = 'thumb_db_generation'
    description = 'ThumbDB generation'
    required = True


class VideoStoreShardmap(MediaStoreShardmap):
    """Переключение большой базы Видео"""

    type = 'VIDEO_STORE_SHARDMAP'
    input_parameters = MediaStoreShardmap.input_parameters + (ShardmapType, PrimaryShardsCount, ThumbDBGeneration,)

    # type to switch
    switch_type = 'video'

    # task to release for shard
    SHARDMAP_RESOURCE = 'VIDEO_BASE_SHARDMAP'

    # sandbox tasks for nanny
    UPLOAD_TASK = "UPLOAD_VIDEO_DATABASE_NG"
    WAIT_UPLOAD_TASK = "WAIT_UPLOAD_VIDEO_DATABASE"

    # YDL
    YDL_TOKEN_NAME = 'ydl_video_token'

    # Monitoring settings
    monitoring_sleep = 3 * 60  # 3 min
    monitoring_time = 30 * 60  # 30 min
    monitoring_telegram_chat_id = '-1001117977095'
    monitoring_email_to = 'video-newdb@yandex-team.ru'
    monitoring_vault_name = 'video-warden-bot-token'
    monitoring_vault_owner = 'VIDEO-ROBOT'

    def initCtx(self):
        MediaStoreShardmap.initCtx(self)

        # override inputs
        self.ctx[ShardmapType.name] = self.SHARDMAP_RESOURCE
        self.ctx[SwitchDashboardName.name] = SWITCH_DASHBOARD_NAME
        self.ctx[SwitchDashboardGroups.name] = SWITCH_DASHBOARD_GROUPS

        # for cancelation
        self.ctx[NewDBDashboardName.name] = NEWDB_DASHBOARD_NAME
        self.ctx[RollbackActivateRecipe.name] = ROLLBACK_ACTIVE_RECIPE

    def _generate_shardmap_filename(self):
        "Generate shardmap filename using index_state and thumb_generation"
        return "shardmap-{0}-{1}.map".format(
            self.ctx[ThumbDBGeneration.name],
            self.ctx[IndexState.name])

    def generate_all_shardmap(self, state, meta_state, shardmap_file):
        # generate vidsidx VideoTier0
        count = int(self.ctx.get(PrimaryShardsCount.name))
        for shard in range(count):
            shardmap_file.write(self.shardmap_entry('vidsidx', shard, state, 'VideoTier0'))


__Task__ = VideoStoreShardmap
