# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc
from sandbox.projects import resource_types
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import LastReleasedResource
from sandbox.sandboxsdk.parameters import SandboxBoolParameter
from sandbox.projects.common import footers
from sandbox.projects.common.dolbilka import DolbilkaExecutor
from sandbox.projects.common.search import components as search_components
# from projects.common.search.settings import VideoSettings

from sandbox.projects.common.search.BaseTestSuperMindTask import SuperMindModeParameter
from sandbox.projects.common.search.BaseTestSuperMindTask import MultParameter
from sandbox.projects.common.search.BaseTestSuperMindTask import EnableSuperMindParameter
from sandbox.projects.common.search.BaseTestSuperMindTask import supermind_component_creator


class PlanParameter(LastReleasedResource):
    name = 'dolbilo_plan_resource_id'
    description = 'Plan'
    resource_type = resource_types.BASESEARCH_PLAN


class RunProfilerParameter(SandboxBoolParameter):
    name = 'run_profiler'
    description = 'Run profiler'
    default_value = False


_BASESEARCH_PARAMS = search_components.DefaultVideosearchParams
_INPUT_PARAMS = _BASESEARCH_PARAMS.params + DolbilkaExecutor.input_task_parameters + (PlanParameter, RunProfilerParameter)


class VideoTestBasesearchPerformance(SandboxTask):
    """
        Задача для проверки производительности базового
        видео поиска. Полная копия таски от картинок.
    """

    type = 'VIDEO_TEST_BASESEARCH_PERFORMANCE'

    client_tags = ctc.Tag.LINUX_PRECISE

    input_parameters_without_supermind = _INPUT_PARAMS
    input_parameters = _INPUT_PARAMS + (EnableSuperMindParameter, SuperMindModeParameter, MultParameter)

    @property
    def footer(self):
        return footers.exec_stats_footer(self)

    def on_execute(self):
        # VideoSettings.ensure_search_database(
        #     self.ctx, PlanParameter, _BASESEARCH_PARAMS.Database)

        component_creator = None
        if self.ctx.get(EnableSuperMindParameter.name, False):
            component_creator = supermind_component_creator(
                supermind_mode=self.ctx[SuperMindModeParameter.name],
                supermind_multiplier=self.ctx[MultParameter.name]
            )

        profiler_enabled = self.ctx.get(RunProfilerParameter.name, RunProfilerParameter.default_value)
        basesearch = search_components.get_basesearch(
            use_profiler=profiler_enabled,
            use_gperftools=profiler_enabled,
            component_creator=component_creator
        )
        self.init_search_component(basesearch)

        plan = self.sync_resource(self.ctx[PlanParameter.name])

        d_executor = DolbilkaExecutor()
        results = d_executor.run_sessions(plan, basesearch, run_once=True)

        self.ctx['results'] = results
        self.ctx['requests_per_sec'] = []
        for result in results:
            try:
                rps = float(result['rps'])
            except ValueError:
                rps = 0
            self.ctx['requests_per_sec'].append(rps)
        self.ctx['max_rps'] = max(self.ctx['requests_per_sec'])

    def get_results(self):
        if not self.is_completed():
            return 'Results are not ready yet.'

        return 'Max rps: %s. All rps: %s' % (self.ctx.get('max_rps', 'unknown'),
                                             self.ctx.get('requests_per_sec', 'unknown'))

    def get_short_task_result(self):
        if not self.is_completed():
            return None

        rps = self.ctx.get('max_rps', None)
        if rps:
            return str(rps)

    def init_search_component(self, search_component):
        pass


__Task__ = VideoTestBasesearchPerformance
