# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import parameters

from sandbox.projects.VideoTestBasesearchPerformance import VideoTestBasesearchPerformance
from sandbox.projects.VideoTestBasesearchPerformanceSSD import VideoTestBasesearchPerformanceSSD
from sandbox.projects.common.TestPerformanceBest import BaseTestPerformanceBestTask


class RunOnSSDParameter(parameters.SandboxBoolParameter):
    name = 'run_on_ssd'
    description = 'Run on SSD'
    default_value = False


class VideoTestBasesearchPerformanceBest(BaseTestPerformanceBestTask):
    """
        Параллельный запуск тестирования базового с последующей агрегацией результатов.
        Запусается указанное количество подзадач типа TEST_BASESEARCH_PERFORMANCE (параметр number_of_runs)

        Выбирается лучший обстрел.
        Полная копия таски от картинок.
    """

    type = 'VIDEO_TEST_BASESEARCH_PERFORMANCE_BEST'

    input_parameters_without_supermind = \
        BaseTestPerformanceBestTask.input_parameters + \
        VideoTestBasesearchPerformance.input_parameters_without_supermind + \
        (RunOnSSDParameter,)

    input_parameters = \
        BaseTestPerformanceBestTask.input_parameters + \
        VideoTestBasesearchPerformance.input_parameters + \
        (RunOnSSDParameter,)

    def _get_default_cpu_model(self):
        return 'e5-2650'

    def _get_performance_task_type(self):
        if self.ctx.get(RunOnSSDParameter.name):
            return VideoTestBasesearchPerformanceSSD.type
        else:
            return VideoTestBasesearchPerformance.type


__Task__ = VideoTestBasesearchPerformanceBest
