# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects import VideoTestDynamicModelsArchive as test_mod_base
from sandbox.projects.common import utils
from sandbox.projects.common.search import settings as media_settings

from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk.parameters import ResourceSelector

_PRIEMKA_SOURCE = media_settings.VideoSettings.PRIEMKA_SOURCE


class ModelsArchiveParameter(ResourceSelector):
    """
        Архив с динамическими моделями
    """

    name = 'models_archive_resource_id'
    description = 'Models archive'
    resource_type = resource_types.VIDEO_MIDDLE_DYNAMIC_MODELS_ARCHIVE
    required = True


class VideoTestMiddleDynamicModelsArchive(test_mod_base.VideoTestDynamicModelsArchive):
    """
        Проверяет что базовый поиск корректно работает с dynamic models archive (архив с формулами):
        Находит archiver, достает из архива имена формул
        Находит базовый, достает из него имена формул
        Формирует файл запросов и запускает дочерний таск GET_BASESEARCH_RESPONSES
    """

    type = 'VIDEO_TEST_MIDDLE_DYNAMIC_MODELS_ARCHIVE'

    archive_parameter = ModelsArchiveParameter

    def _get_basesearch_responses(self, videosearch_id, archive_id, queries_id):
        """
            Запуск подзадачи для тестирования
            среднего поиска
        """

        self.set_info('Run middle video search with ranking models archive.')
        testenv_attributes = media_settings.VideoSettings.testenv_resource_attributes(
            media_settings.VideoSettings.MMETA_ID, _PRIEMKA_SOURCE[1])

        config_id = utils.get_and_check_last_resource_with_attribute(
            resource_types.VIDEO_MIDDLESEARCH_CONFIG,
            testenv_attributes[0],
            testenv_attributes[1]
        ).id

        data_id = utils.get_and_check_last_resource_with_attribute(
            resource_types.VIDEO_MIDDLESEARCH_DATA,
            testenv_attributes[0],
            testenv_attributes[1]
        ).id

        rearrange_index_id = utils.get_and_check_last_resource_with_attribute(
            resource_types.VIDEO_MIDDLESEARCH_INDEX,
            testenv_attributes[0],
            testenv_attributes[1]
        ).id

        sub_ctx = {
            'basesearch_type': 'videosearch',
            'middlesearch_executable_resource_id': test_mod_base._get_last_released_resource_id(resource_types.VIDEO_RANKING_MIDDLESEARCH_EXECUTABLE),
            'middlesearch_config_resource_id': config_id,
            'middlesearch_data_resource_id': data_id,
            'middlesearch_index_resource_id': rearrange_index_id,
            'middlesearch_models_archive_resource_id': archive_id,

            'basesearch1_executable_resource_id': videosearch_id,
            'basesearch1_config_resource_id': test_mod_base._get_last_released_resource_id(resource_types.VIDEO_SEARCH_CONFIG, arch='any'),
            'basesearch1_database_resource_id': test_mod_base._get_priemka_resource_id(resource_types.VIDEO_SEARCH_DATABASE),
            'basesearch1_models_archive_resource_id': test_mod_base._get_last_released_resource_id(resource_types.VIDEO_DYNAMIC_MODELS_ARCHIVE, arch='any'),

            'basesearch2_executable_resource_id': videosearch_id,
            'basesearch2_config_resource_id': test_mod_base._get_last_released_resource_id(resource_types.VIDEO_SEARCH_CONFIG, arch='any'),
            'basesearch2_database_resource_id': test_mod_base._get_priemka_resource_id(resource_types.VIDEO_SEARCH_DATABASE),
            'basesearch2_models_archive_resource_id': test_mod_base._get_last_released_resource_id(resource_types.VIDEO_DYNAMIC_MODELS_ARCHIVE, arch='any'),

            'queries_resource_id': queries_id,
            'get_all_factors': True,
            'recheck_results_n_times': 1,
            'process_count': 4,  # as in web (do not overshoot basesearch (SEARCH-1044))
        }
        sub_task = self.create_subtask(
            task_type='VIDEO_GET_MIDDLESEARCH_RESPONSES',
            input_parameters=sub_ctx,
            description=self.descr,
            arch=sandboxapi.ARCH_LINUX,
        )

        return sub_task.id


__Task__ = VideoTestMiddleDynamicModelsArchive
