# -*- coding: utf-8 -*-

from sandbox.projects.websearch.middlesearch import TestMiddlesearchCacheReload as base

from sandbox.projects import resource_types
from sandbox.projects.common.search import components
from sandbox.projects.common.base_search_quality import threadPool
from sandbox.projects.common.base_search_quality import response_saver
from sandbox.projects.common.search import settings as media_settings

_BASESEARCH1_PARAMS = components.create_noweb_basesearch_params(n=1)
_BASESEARCH2_PARAMS = components.create_noweb_basesearch_params(n=2)
_RESPONSE_SAVER_PARAMS = response_saver.create_response_saver_params(
    queries_resource=resource_types.VIDEO_MIDDLESEARCH_PLAIN_TEXT_REQUESTS
)


class VideoTestMiddlesearchCacheReload(base.TestMiddlesearchCacheReload):
    """
        Тестирует обновление кеша, используя TestMiddlesearchCacheReload как основу (SEARCH-1007, VIDEOPOISK-4748)
    """

    type = 'VIDEO_TEST_MIDDLESEARCH_CACHE_RELOAD'

    input_parameters = _BASESEARCH1_PARAMS.params + _BASESEARCH2_PARAMS.params + components.DefaultMiddlesearchParams.params + _RESPONSE_SAVER_PARAMS.params + threadPool.PARAMS + (base.WaitTime,)

    def on_enqueue(self):
        media_settings.VideoSettings.ensure_search_database(
            self.ctx,
            self._get_queries_parameter(),
            _BASESEARCH1_PARAMS.Database,
            _BASESEARCH2_PARAMS.Database,
        )

        base.TestMiddlesearchCacheReload.on_enqueue(self)

    def _get_queries_parameter(self):
        return _RESPONSE_SAVER_PARAMS.QueriesParameter


__Task__ = VideoTestMiddlesearchCacheReload
