# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.sandboxsdk import parameters
from sandbox.projects.common.dolbilka import DolbilkaExecutor
from sandbox.projects.common import footers
from sandbox.projects.common.middlesearch import video_single_host
from sandbox.projects.common.search.settings import VideoSettings


class PlanParameter(parameters.LastReleasedResource):
    name = 'dolbilo_plan_resource_id'
    description = 'Plan'
    resource_type = resource_types.VIDEO_MIDDLESEARCH_PLAN


class CustomBanParameter(parameters.ResourceSelector):
    name = 'custom_ban_resource_id'
    description = 'Custom ban or other subresource'
    resource_type = VideoSettings.MIDDLE_DATA_SUBRESOURCES
    required = False


class VideoTestMiddlesearchPerformance(video_single_host.VideoMiddlesearchSingleHostTask):
    """
        1 middlesearch 2 basesearch instances on single host + d-executor
    """

    type = 'VIDEO_TEST_MIDDLESEARCH_PERFORMANCE'

    input_parameters = \
        video_single_host.VideoMiddlesearchSingleHostTask.input_parameters \
        + (PlanParameter, CustomBanParameter,) \
        + DolbilkaExecutor.input_task_parameters

    @property
    def footer(self):
        return footers.exec_stats_footer(self)

    def get_results(self):
        if not self.is_completed():
            return 'Results are not ready yet.'

        return 'Max rps: %s. All rps: %s' % (self.ctx.get('max_rps', 'unknown'),
                                             self.ctx.get('requests_per_sec', 'unknown'))

    def get_short_task_result(self):
        if not self.is_completed():
            return None

        rps = self.ctx.get('max_rps', None)
        if rps:
            return str(rps)

    def _get_queries_parameter(self):
        return PlanParameter

    def init_search_component(self, middlesearch):
        middlesearch.disable_cache()

    def _use_middlesearch_component(self, middlesearch):
        plan = self.sync_resource(self.ctx[PlanParameter.name])

        d_executor = DolbilkaExecutor()
        results = d_executor.run_sessions(plan, middlesearch, run_once=True, need_warmup=True)

        self.ctx['results'] = results
        self.ctx['requests_per_sec'] = [float(i['rps']) for i in results]
        self.ctx['max_rps'] = max(self.ctx['requests_per_sec'])

    def _get_resource_type_for_ensure_custom_ban(self):
        return resource_types.VIDEO_MIDDLESEARCH_DATA


__Task__ = VideoTestMiddlesearchPerformance
