import logging

from sandbox.projects.VpsBuild import VpsBuildTask, VpsVcsUrlParam
from sandbox.projects.common.apihelpers import get_last_resource_with_attrs
from sandbox.projects.resource_types import VPS_DIST
from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.process import run_process


class VpsBuildCiTask(VpsBuildTask):
    type = 'VPS_BUILD_CI'

    def on_execute(self):
        if self.ctx.get('subtask'):
            subtask = channel.sandbox.get_task(self.ctx['subtask'])
            self.create_release(subtask.id, sandboxapi.RELEASE_UNSTABLE, subject=subtask.description)
        else:
            url = self.ctx[VpsVcsUrlParam.name]
            rev = run_process(
                ['git', 'ls-remote', url, 'master', '|', 'cut', '-f1'],
                'git',
                outs_to_pipe=True,
                shell=True
            ).stdout.read().strip()
            res = get_last_resource_with_attrs(VPS_DIST, {"revision": rev})
            if res is None:
                logging.info("resource not found for revision %s" % (rev,))
                subtask = self.create_subtask(VpsBuildTask.type, VpsBuildTask.type)
                self.ctx['subtask'] = subtask.id
                self.wait_task_completed(subtask)
            else:
                logging.info("resource found  %s for revision %s" % (res.id, rev))

    def on_release(self, additional_parameters):
        pass


__Task__ = VpsBuildCiTask
