from sandbox.projects.common.nanny import nanny
from sandbox.projects.resource_types import VPS_CUSTOM_CONFIG
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.task import SandboxTask


class WtrokaParam(SandboxStringParameter):
    name = 'wtroka_cgi'
    description = 'TUtf16String parameters'
    default_value = ''


class IsrpParam(SandboxStringParameter):
    name = 'isrp_cgi'
    description = 'Isrp parameters'
    default_value = ''


class VpsParam(SandboxStringParameter):
    name = 'vps_cgi'
    description = 'Vps parameters'
    default_value = ''


class ResourceNameParam(SandboxStringParameter):
    name = 'resource_name'
    description = 'Resource'
    default_value = 'vps-custom.conf'


# noinspection PyAbstractClass
class VpsCustomConfigTask(SandboxTask, nanny.ReleaseToNannyTask):
    execution_space = 10

    type = 'VPS_CUSTOM_CONFIG'

    input_parameters = (
        ResourceNameParam,
        WtrokaParam,
        IsrpParam,
        VpsParam
    )

    def on_execute(self):
        resource = self.ctx[ResourceNameParam.name]
        with open(resource, 'w') as res:
            cgi = self.ctx[WtrokaParam.name]
            if cgi:
                res.write('wtroka.cgi = \"%s\"\n\n' % cgi)
            cgi = self.ctx[IsrpParam.name]
            if cgi:
                res.write('isrp.cgi = \"%s\"\n\n' % cgi)
            cgi = self.ctx[VpsParam.name]
            if cgi:
                res.write('vps.cgi = \"%s\"\n\n' % cgi)
        res = self.create_resource('vps custom config', resource, VPS_CUSTOM_CONFIG)
        self.mark_resource_ready(res)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        SandboxTask.on_release(self, additional_parameters)

    @property
    def release_template(self):
        return self.ReleaseTemplate(subject=self.descr)


__Task__ = VpsCustomConfigTask
