import logging

from sandbox import sdk2
from sandbox.common.telegram import TelegramBot
from sandbox.sandboxsdk import environments


class WmsSupportCheckRoleAdmin(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group("WMS database settings", collapse=True) as wms_db_settings:
            wms_db_host = sdk2.parameters.String('WMS database host', required=True)
            wms_db_port = sdk2.parameters.String('WMS database port', required=True)
            wms_db_name = sdk2.parameters.String('WMS database name', required=True)
            wms_db_user_secret = sdk2.parameters.YavSecret(
                'WMS database username'
                '\nYAV secret identifier (with optional version)'
                '\nDefault key: username',
                required=True
            )
            wms_db_password_secret = sdk2.parameters.YavSecret(
                'WMS database password '
                '\nYAV secret identifier (with optional version)'
                '\nDefault key: password',
                required=True
            )
        telegram_bot_token_vault_key = sdk2.parameters.String('Telegram bot token key', required=True)
        telegram_chat_id = sdk2.parameters.String('Telegram chat id', required=True)
        st_user_agent = sdk2.parameters.String('Startrack user agent', required=True)
        st_url = sdk2.parameters.String('Startrack url', required=True)
        st_token_vault_key = sdk2.parameters.String('Startrack token vault key', required=True)
        st_queue = sdk2.parameters.String('Startrack queue', required=True)
        st_summary = sdk2.parameters.String('Startrack ticket summary', required=True)

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5
        environments = (environments.PipEnvironment('pymssql==2.1.4'),
                        environments.PipEnvironment('yandex_tracker_client', version="1.3",
                                                    custom_parameters=["--upgrade-strategy only-if-needed"]),
                        environments.PipEnvironment('startrek_client', version="2.3.0",
                                                    custom_parameters=["--upgrade-strategy only-if-needed"]))

    def create_wms_connection(self, user, password, host, port, whid):
        data = ''
        logging.info('Connecting to WMS, warehouse ' + whid)
        _pymssql = __import__('pymssql')
        conn = _pymssql.connect(user=user,
                                password=password,
                                host=host,
                                port=port)
        logging.info('Connected')
        cur = conn.cursor()
        cur.execute(
            """SELECT externuserid, sso_role_name
            FROM        SCPRDD1.dbo.e_sso_user_role AS ESUL
            INNER JOIN  SCPRDD1.dbo.e_sso_role      AS ESR
            ON ESUL.sso_role_id=ESR.e_sso_role_id
            where sso_role_name like '%SCE-Administrator%'"""
        )
        row = cur.fetchone()
        data = ''
        while row:
            data += 'User\t' + row[0] + '\thas role\t' + row[1] + '\ton ' + whid + '\n'
            row = cur.fetchone()
        return data

    def on_execute(self):
        bot = TelegramBot(bot_token=sdk2.Vault.data(self.Parameters.telegram_bot_token_vault_key))
        wms_db_user = self.Parameters.wms_db_user_secret.data()
        wms_db_user_key = self.Parameters.wms_db_user_secret.default_key or 'username'
        wms_db_user = wms_db_user[wms_db_user_key]
        wms_db_password = self.Parameters.wms_db_password_secret.data()
        wms_db_password_key = self.Parameters.wms_db_password_secret.default_key or 'password'
        wms_db_password = wms_db_password[wms_db_password_key]
        wms_db_host = self.Parameters.wms_db_host
        wms_db_port = self.Parameters.wms_db_port
        whid = 'Sofino'
        result = 'Alert\n'
        result += self.create_wms_connection(wms_db_user, wms_db_password, wms_db_host, wms_db_port, whid)
        logging.info(result)
        bot.send_message(self.Parameters.telegram_chat_id, result)
