#! /usr/bin/env python
# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment
import requests


def related_links(client):
    # Проверка смежных ссылок
    links_issue = client.issues.find('Queue: WAREHOUSESUP Created: >now()-14d Status: "Смежная служба"')
    secret2 = sdk2.yav.Secret('sec-01g4mrnaya78dzn3phbedbwy20')
    tg_token = secret2.data()['tg-samwhit_bot']
    secret22 = sdk2.yav.Secret('sec-01g42qa0rfnycpvpw6b4j581rg')
    volga_bot_key = secret22.data()['volgawhtgbot']
    secret3 = sdk2.yav.Secret('sec-01g4j6rms4rzw2d6vragj4y7p3')
    spb_bot_key = secret3.data()['spbwhtgbot']
    secret4 = sdk2.yav.Secret('sec-01g4j70a5eje69jpv55grzhhnh')
    center_bot_key = secret4.data()['centerwhbot']
    secret5 = sdk2.yav.Secret('sec-01g4j6z2exkxbfy8m0ksazfshr')
    south_bot_key = secret5.data()['southwhtgbot']
    secret6 = sdk2.yav.Secret('sec-01g4j6t7wm45r6zje0ge1np4em')
    ural_bot_key = secret6.data()['uralwhtgbot']
    secret7 = sdk2.yav.Secret('sec-01g4jc2n33g5egwn4vb26dd7tx')
    sof_bot_key = secret7.data()['softgwhbot']
    st_link = "https://st.yandex-team.ru/"
    region_chat = {r"ФФЦ/СЦ_Регион_Поволжье": ["-1001514260726", volga_bot_key],
                   r"ФФЦ/СЦ_Регион_СПБ": ["-1001634158704", spb_bot_key],
                   r"ФФЦ/СЦ_Регион_Центр": ["-1001604523486", center_bot_key],
                   r"ФФЦ/СЦ_Регион_ЮГ": ["-1001796424873", south_bot_key],
                   r"ФФЦ/СЦ_Регион_Урал": ["-1001735112531", ural_bot_key],
                   r"МСК_Софьино": ["-1001764544075", sof_bot_key]}
    chat_id = "-1001604523486"
    chat_token = center_bot_key
    done_status = ["Закрыт", "Решен"]
    for i in links_issue:
        links = i.links.get_all()
        change_status = bool
        if i.tags:
            for key in region_chat:
                for s in i.tags:
                    if s == key:
                        chat_id = region_chat[key][0]
                        chat_token = region_chat[key][1]
        if len(links) == 0:
            i.transitions['inProgress'].execute()
            new_comm = ('Привет, ' + i.assignee.firstName + '.\n' +
                        'Использование статуса Смежная служба требует наличие ' +
                        'привязанного тикета, в котором идут работы')
            i.comments.create(text=new_comm, summonees=i.assignee.login)
            message_text = '<a href="' + st_link + i.key + '">' + i.summary + '</a>\n' + \
                           'Укажите ссылку на связанный тикет! Статус задачи переведен в работу'
            request_url = "https://api.telegram.org/bot" + chat_token + "/sendMessage"
            data = {"chat_id": chat_id, "parse_mode": "html", "text": message_text}
            requests.post(request_url, data=data)
            break
        for lnk in links:
            try:
                if lnk.object.status.name not in done_status:
                    change_status = False
                    break
                if lnk.object.status.name in done_status:
                    change_status = True
            except Exception:
                change_status = False
                chat_id = "351045854"
                message_text = 'Related_links: <a href="' + st_link + i.key + '">' + i.key + \
                               '</a> Ошибка доступа к связанному тикету'
                request_url = "https://api.telegram.org/bot" + tg_token + "/sendMessage"
                data = {"chat_id": chat_id, "parse_mode": "html", "text": message_text}
                requests.post(request_url, data=data)
        if change_status is True:
            i.transitions['inProgress'].execute()
            new_comm = ('Привет, ' + i.assignee.firstName +
                        '\nСвязанная задача решена')
            i.comments.create(text=new_comm, summonees=i.assignee.login)
            message_text = '<a href="' + st_link + i.key + '">' + i.summary + '</a>\n' + \
                           u'\u2757 Связанный тикет решен. \u2757' + '\nСтатус задачи переведен в работу'
            request_url = "https://api.telegram.org/bot" + chat_token + "/sendMessage"
            data = {"chat_id": chat_id, "parse_mode": "html", "text": message_text}
            requests.post(request_url, data=data)


class RelatedLinksCheckerWHS(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [PipEnvironment('startrek_client')]

    def on_execute(self):
        from startrek_client import Startrek
        secret = sdk2.yav.Secret('sec-01g38w5733kwbysy07p237ddj4')
        st_token = secret.data()['treck-oauth']
        client = Startrek(useragent="python", token=st_token)
        related_links(client=client)
