import logging

from sandbox import sdk2
from sandbox.common.telegram import TelegramBot
from sandbox.sandboxsdk import environments


class WmsSupportTelegramTest(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        telegram_bot_token_vault_key = sdk2.parameters.String('Telegram bot token key', required=True)
        telegram_chat_id = sdk2.parameters.String('Telegram chat id', required=True)

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5
        environments = (environments.PipEnvironment('pymssql==2.1.4'))

    def on_execute(self):
        bot = TelegramBot(bot_token=sdk2.Vault.data(self.Parameters.telegram_bot_token_vault_key))
        telegram_message = 'Hello world!\n\n'
        logging.info(telegram_message)
        bot.send_message(self.Parameters.telegram_chat_id, telegram_message)
