#! /usr/bin/env python
# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment
from datetime import datetime, timedelta
import requests


def tags_checker(client):
    # Проверка установки тэгов
    tags_issues = client.issues.find('Queue: WAREHOUSESUP Created: >now()-48h Status: !"Новый"')
    checking_tags = ['Инстал_оборудования', 'Подключение_оборудования', 'Не_доступно_оборудование',
                     'Замена_оборудования',
                     'Новая_сеть', 'Нет_линка', 'Роль_IDM_ТОТР', 'AD_Пароль', 'УЗ_пользователя', 'Сертификат',
                     'Настройка_ABC', 'Проблема_WMS', 'Настройка_WMS', 'Настройка_моб', 'Puncher', 'PDA',
                     'ИБП_монтаж_демонтаж', 'АКБ_установка_замена', 'Мониторинг_подключение', 'ИПБ_нет_связи',
                     'ИБТ_авария',
                     'ИПБ_переключение_нагрузки', 'Канал_настройка', 'Канал_не_работает', 'Канал_тестирование',
                     'Смена_провайдера', 'Сопровождение_работ', 'Установка_телефона', 'ВКС_монтаж_демонтаж',
                     'ВКС_настройка', 'ВКС_не_работает', 'ЭО_монтаж_демонтаж', 'ЭО_настройка', 'ЭО_не_работает',
                     'МФУ_настройка', 'Nuc_наливка', 'Сервер_монтаж_демонтаж', 'ТСД_настройка', 'Печать_пропуска',
                     'Приемка', 'Патчкорд', 'МФУ_не_печатает', 'Ноутбук_наливка_выдача', 'Замена_комплектующих',
                     'ТСД_не_доступен', 'Настройка_доступов_помещение', 'Отправка', 'Кроссировка', 'Замена_расходника',
                     'УЗ_ноутбук', 'Сервер_замена', 'ТСД_выдача', 'Проблема_камера_регистратор_скуд', 'Проводки_в_OEBS',
                     'СКС_тестирование', 'Принтер_этикеток_настройка', 'ПО_ноутбук', 'IPMI_настройка',
                     'Батарея_неисправна',
                     'Задачи_физбез', 'Выдача оборудования подрядчику', 'Северная_доступ',
                     'Принтер_этикеток_не_печатает', 'ВГХ_настройка', 'ТСД_зависание', 'Регулировка_замка_доводчика',
                     'Монитор_выдача', 'Аудит', 'Принтер_этикеток_чистка', 'ВГХ_монтаж_демонтаж', 'Обновление_прошивки',
                     'Турникет_Трипод_УРД', 'Клавиатура_мышь_выдача', 'ВОЛС', 'Сканер_поточный_настройка',
                     'DataLens_киоск_настройка', 'Биометрия_не_работает', 'Инвентаризация_склад_IT',
                     'Сканер_поточный_замена_расходки', 'DataLens_киоск_монтаж', 'Датчики_монтаж - демонта',
                     'Инвентаризация_склад', 'Ноутбук_не_работает', 'Мониторинг_проблема', 'Инвентаризация_ТСД',
                     'Монитор_не_работает', 'Клавиатура_мышь_не_работает', 'ППР', 'Поиск_ТСД', 'Иное', 'Конкурс',
                     'Обход']
    table_links = "((https://yandexteam.sharepoint.com/:x:/r/sites/WH_ARTIFACTS/_layouts/15/" \
                  "Doc.aspx?sourcedoc=%7BF61EDB20-EAEE-48C2-B5C4-25A96D705E37%7D&file=Сервисы.xlsx&" \
                  "action=default&mobileredirect=true&cid=fc153664-8cc4-486a-a057-160065a8733c Таблица))"
    for i in tags_issues:
        need_tag = True
        checked_before = False
        current_time = datetime.now() - timedelta(hours=3)
        start_status_time = datetime.strptime(i.statusStartTime.replace('+0000', ''), "%Y-%m-%dT%H:%M:%S.%f")
        status_long = (current_time - start_status_time).total_seconds() / 60
        for tag in i.tags:
            if tag in checking_tags:
                need_tag = False
        if need_tag is True:
            if status_long > 10:
                comments = list(i.comments.get_all())
                for com in comments:
                    if com.text.find("необходимо указать тэг") != -1:
                        checked_before = True
                if checked_before is False:
                    try:
                        text_to_comm = ('Привет, ' + i.assignee.firstName +
                                        '\nВ тикете необходимо указать тэг, поможет определиться эта ' +
                                        table_links + ' и убедись, что выставлена верная услуга (сервис)')
                        i.comments.create(text=text_to_comm, summonees=i.assignee.login)
                    except Exception:
                        pass


class WhSlaHelper(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [PipEnvironment('startrek_client')]

    def on_execute(self):
        from startrek_client import Startrek
        secret = sdk2.yav.Secret('sec-01g38w5733kwbysy07p237ddj4')
        st_token = secret.data()['treck-oauth']
        client = Startrek(useragent="python", token=st_token)
        issues = client.issues.find('Queue: WAREHOUSESUP Created: >now()-48h Type: !"task" Tags: !"sla-alert-bot"')
        secret2 = sdk2.yav.Secret('sec-01g42qa0rfnycpvpw6b4j581rg')
        volga_bot_key = secret2.data()['volgawhtgbot']
        secret3 = sdk2.yav.Secret('sec-01g4j6rms4rzw2d6vragj4y7p3')
        spb_bot_key = secret3.data()['spbwhtgbot']
        secret4 = sdk2.yav.Secret('sec-01g4j70a5eje69jpv55grzhhnh')
        center_bot_key = secret4.data()['centerwhbot']
        secret5 = sdk2.yav.Secret('sec-01g4j6z2exkxbfy8m0ksazfshr')
        south_bot_key = secret5.data()['southwhtgbot']
        secret6 = sdk2.yav.Secret('sec-01g4j6t7wm45r6zje0ge1np4em')
        ural_bot_key = secret6.data()['uralwhtgbot']
        secret7 = sdk2.yav.Secret('sec-01g4jc2n33g5egwn4vb26dd7tx')
        sof_bot_key = secret7.data()['softgwhbot']
        st_link = "https://st.yandex-team.ru/"
        region_chat = {r"ФФЦ/СЦ_Регион_Поволжье": ["-1001514260726", volga_bot_key],
                       r"ФФЦ/СЦ_Регион_СПБ": ["-1001634158704", spb_bot_key],
                       r"ФФЦ/СЦ_Регион_Центр": ["-1001604523486", center_bot_key],
                       r"ФФЦ/СЦ_Регион_ЮГ": ["-1001796424873", south_bot_key],
                       r"ФФЦ/СЦ_Регион_Урал": ["-1001735112531", ural_bot_key],
                       r"МСК_Софьино": ["-1001764544075", sof_bot_key]}
        # Уведомление о срыве SLA
        for i in issues:
            for k in i.sla:
                if k['clockStatus'] == "STARTED" and k['failAt']:
                    current_time = datetime.now() - timedelta(hours=3)
                    start_sla_time = datetime.strptime((k['startedAt']).replace('+0000', ''), "%Y-%m-%dT%H:%M:%S.%f")
                    fail_sla_time = datetime.strptime((k['failAt']).replace('+0000', ''), "%Y-%m-%dT%H:%M:%S.%f")
                    sla_time = (fail_sla_time - start_sla_time).total_seconds()
                    now_sla_time = (current_time - start_sla_time).total_seconds()
                    percent_sla = (now_sla_time * 100) / sla_time
                    current_tags = i.tags
                    chat_id = "-1001604523486"
                    tg_token = center_bot_key
                    if i.tags:
                        for key in region_chat:
                            for s in i.tags:
                                if s == key:
                                    chat_id = region_chat[key][0]
                                    tg_token = region_chat[key][1]
                    message_text = u'\U0001f4a5 <b>SLA истекает</b> \U0001f4a5\n' + '<i>' + i.summary + \
                                   '</i>\n' + '<a href="' + st_link + i.key + '">' + i.key + '</a>'
                    request_url = "https://api.telegram.org/bot" + tg_token + "/sendMessage"
                    data = {"chat_id": chat_id, "parse_mode": "html", "text": message_text}
                    if i.status.name == "Новый" and percent_sla > 40:
                        requests.post(request_url, data=data)
                        new_tag = "sla-alert-bot"
                        current_tags.append(new_tag)
                        i.update(tags=current_tags)
                    if i.status.name != "Новый" and percent_sla > 80:
                        requests.post(request_url, data=data)
                        current_tags = i.tags
                        new_tag = "sla-alert-bot"
                        current_tags.append(new_tag)
                        i.update(tags=current_tags)

        # Поиск тикетов на увольнение
        dismissal_issues = client.issues.find(
            'Queue: WAREHOUSESUP Created: >now()-1h Type: !"task" Tags: "DISMISSAL" Tags: !"dism-bot" Status: "Новый"')
        wh_dict = {"ФФЦ Маркет, Самара": ["-1001514260726", volga_bot_key, "ФФЦ Самара"],
                   "СЦ Маркет, Нижний-Новгород": ["-1001514260726", volga_bot_key, "СЦ Нижний Новгород Кстово"],
                   "СЦ Маркет, Самара": ["-1001514260726", volga_bot_key, "СЦ Самара"],
                   "ФФЦ \"Парголово\", Санкт-Петербург": ["-1001634158704", spb_bot_key, "ФФЦ Санкт-Петербург"],
                   "СЦ Маркет, Екатеринбург": ["-1001735112531", ural_bot_key, "СЦ Екатеринбург"],
                   "ФФЦ Маркета, Екатеринбург": ["-1001735112531", ural_bot_key, "ФФЦ Екатеринбург"],
                   "ФФЦ Маркета, Ростов": ["-1001796424873", south_bot_key, "ФФЦ Ростов-на-Дону"],
                   "ФФЦ Софьино": ["-1001796424873", south_bot_key, "ФФЦ Москва-Софьино"],
                   }
        for i in dismissal_issues:
            issue_description = i.description
            if issue_description:
                for key in wh_dict:
                    if issue_description.find(key) != -1:
                        i.update(components=wh_dict[key][2])
                        new_tags = i.tags
                        new_tags.append("dism-bot")
                        i.update(tags=new_tags)
                        chat_id = wh_dict[key][0]
                        tg_token = wh_dict[key][1]
                        message_text = 'Новый тикет на увольнение \n'+\
                                       '<a href="' + st_link + i.key + '">' + i.summary + '</a>'
                        request_url = "https://api.telegram.org/bot" + tg_token + "/sendMessage"
                        data = {"chat_id": chat_id, "parse_mode": "html", "text": message_text}
                        requests.post(request_url, data=data)

        # Поиск брошенных тикетов
        lost_issues = client.issues.find(
            'Queue: WAREHOUSESUP Created: >now()-24h Type: !"task" Tags: !"lost" Status:"Новый')
        wiki_chats = "((https://wiki.yandex-team.ru/market/sre/warehouse/itsupport/" \
                     "format-obrashhenija-v-texpodderzhku-ffc-i-sc/ макро-региона))"
        for issue in lost_issues:
            for k in issue.sla:
                if k['clockStatus'] == "STARTED" and k['failAt']:
                    current_time = datetime.now() - timedelta(hours=3)
                    start_sla_time = datetime.strptime((k['startedAt']).replace('+0000', ''), "%Y-%m-%dT%H:%M:%S.%f")
                    lost_time = (current_time - start_sla_time).total_seconds() / 3600
                    if lost_time > 3 and k['violationStatus'] == "FAIL_CONDITIONS_VIOLATED":
                        try:
                            new_tags = issue.tags
                            new_tags.append("lost")
                            issue.update(tags=new_tags)
                            comm_text = "Привет, " + issue.createdBy.display + \
                                        "\nЕсли ваш вопрос критичен, эскалируйте " + \
                                        "задачу в чате вашего " + wiki_chats
                            issue.comments.create(text=comm_text, summonees=[issue.createdBy.login, "veretennikovp"])
                        except Exception:
                            pass

        tags_checker(client=client)
