#! /usr/bin/env python
# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment


class SotiAlertComponents(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [PipEnvironment('startrek_client')]

    def on_execute(self):
        from startrek_client import Startrek
        secret = sdk2.yav.Secret('sec-01g38w5733kwbysy07p237ddj4')
        st_token = secret.data()['treck-oauth']
        client = Startrek(useragent="python", token=st_token)
        issues = client.issues.find('Queue: WAREHOUSESUP Created: >now()-1h Tags: "Soti-Alert')
        components_dict = {r"Сортировочные центры\Самара": "СЦ Самара",
                           r"Нижний Новгород\Кстово": "СЦ Нижний Новгород Кстово",
                           r"Склады ФФЦ\Самара": "ФФЦ Самара",
                           r"Санкт-Петербург\Магнитогорская": "СЦ Санкт-Петербург (Магнитогорская)",
                           r"Санкт-Петербург\СЦ Бугры": "СЦ Санкт-Петербург (Бугры)",
                           r"Санкт-Петербург\СЦ Шушары": "СЦ Санкт-Петербург (Шушары)",
                           r"Склады ФФЦ\Санкт-Петербург": "ФФЦ Санкт-Петербург",
                           r"Сортировочные центры\Екатеринбург": "СЦ Екатеринбург",
                           r"Склады ФФЦ\Екатеринбург": "ФФЦ Екатеринбург",
                           r"Сортировочные центры\Ростов-на-Дону\СЦ Ростов": "СЦ Ростов-на-Дону",
                           r"Сортировочные центры\Краснодар\СЦ Краснодар": "СЦ Краснодар (Подсолнечная)",
                           r"Склады ФФЦ\Ростов-На-Дону": "ФФЦ Ростов-на-Дону",
                           r"Сортировочные центры\Москва\Чертаново": "СЦ Москва Чертаново",
                           r"Сортировочные центры\Москва\СЦ Климовск": "СЦ Альфа/Климовск",
                           r"Сортировочные центры\Москва\Пресня": "СЦ Пресня",
                           r"Сортировочные центры\Москва\Дзержинский": "СЦ Дзержинский",
                           r"Склады ФФЦ\Москва\Томилино": "ФФЦ Москва-Томилино",
                           r"Софьино 4\Склад Возвратов": "ФФЦ Москва-Софьино склад Возвратов",
                           r"Софьино 4\Склад КГТ": "ФФЦ Москва-Софьино КГТ",
                           }
        for i in issues:
            issue_description = i.description
            if issue_description:
                for key in components_dict:
                    if issue_description.find(key) != -1:
                        if i.components:
                            need_install_components = True
                            for k in i.components:
                                if k.name == components_dict[key]:
                                    need_install_components = False
                            if need_install_components is True:
                                i.update(components=components_dict[key])
                        else:
                            i.update(components=components_dict[key])
            current_tags = i.tags
            # Добавление тэгов по теме тикета
            if i.summary.find("потеряна связь") != -1:
                need_tag = True
                new_tag = "Поиск_ТСД"
                if new_tag in current_tags:
                    need_tag = False
                if need_tag is True:
                    current_tags.append(new_tag)
                    i.update(tags=current_tags)
            if i.summary.find("необходимо заменить аккумулятор") != -1:
                need_tag = True
                new_tag = "Акб_ТСД"
                if new_tag in current_tags:
                    need_tag = False
                if need_tag is True:
                    current_tags.append(new_tag)
                    i.update(tags=current_tags)
            # Добавление рук склада в наблюдатели WAREHOUSESUP-68551
            for j in i.components:
                if j.name == "СЦ Санкт-Петербург (Шушары)":
                    i.followers.append("nikkuleshov")
                    i.update(followers=i.followers)
                if j.name == "СЦ Санкт-Петербург (Магнитогорская)":
                    i.followers.append("zaytsevatv")
                    i.update(followers=i.followers)
                if j.name == "СЦ Санкт-Петербург (Бугры)":
                    i.followers.append("bogdanov-serg")
                    i.update(followers=i.followers)
