# -*- coding: utf-8 -*-

from sandbox.projects.MediaLib.WaitUploadMediaDatabase import WaitUploadMediaDatabase


class WaitUploadImagesDatabase(WaitUploadMediaDatabase):
    """Waiting for upload database"""

    type = 'WAIT_UPLOAD_IMAGES_DATABASE'

    # type to switch
    switch_type = 'images'

    # sandbox tasks for nanny
    SWITCH_TASK = "SWITCH_IMAGES_DATABASE_NG"

    # instructions for ticket
    SWITCH_GUIDE = "https://wiki.yandex-team.ru/jandekspoisk/sepe/docs/media/perekljucheniekartinochnojjbazy/#1.2perekljuchenieindeksa"
    DASHBOARD_LINK = "https://nanny.yandex-team.ru/ui/#/services/dashboards/catalog/images_all/deployments/catalog/"

    # cc for ticket
    CC_USERS = [
        "images-releases",
        "images-index",
        "ulgen4a",
        "maryzotik",
    ]

    # Monitoring settings
    monitoring_sleep = 10 * 60  # 10 min
    monitoring_time = 7 * 60 * 60  # 7 hours
    monitoring_telegram_chat_id = '-1001088652476'
    monitoring_email_to = 'images-newdb@yandex-team.ru'
    monitoring_vault_name = 'telegram_token'
    monitoring_vault_owner = 'MEDIA_DEPLOY'


__Task__ = WaitUploadImagesDatabase
