# -*- coding: utf-8 -*-

from sandbox.projects.MediaLib.WaitUploadMediaDatabase import WaitUploadMediaDatabase


class WaitUploadVideoDatabase(WaitUploadMediaDatabase):
    """Waiting for upload database"""

    type = 'WAIT_UPLOAD_VIDEO_DATABASE'

    # type to switch
    switch_type = 'video'

    # sandbox tasks for nanny
    SWITCH_TASK = "SWITCH_VIDEO_DATABASE_NG"

    # instructions for ticket
    SWITCH_GUIDE = "https://wiki.yandex-team.ru/jandekspoisk/sepe/docs/media/video/dbswitch/"
    DASHBOARD_LINK = "https://nanny.yandex-team.ru/ui/#/services/dashboards/catalog/video_base/deployments/catalog/"

    # cc for ticket
    CC_USERS = [
        "matveieff",
        "vbiriukov",
    ]

    # Monitoring settings
    monitoring_sleep = 10 * 60  # 10 min
    monitoring_time = 7 * 60 * 60  # 7 hours
    monitoring_telegram_chat_id = '-1001117977095'
    monitoring_email_to = 'video-newdb@yandex-team.ru'
    monitoring_vault_name = 'video-warden-bot-token'
    monitoring_vault_owner = 'VIDEO-ROBOT'


__Task__ = WaitUploadVideoDatabase
