from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.parameters import SandboxStringParameter


class BetaMarker(SandboxStringParameter):
    name = 'beta_marker'
    description = 'Beta marker'


class WizardBuild(SandboxStringParameter):  # tmp fix
    name = 'build_id'
    description = 'BUILD_WIZARD id'


class WizardBeta(SandboxTask):
    type = 'WIZARD_BETA'

    input_parameters = (BetaMarker, WizardBuild)

    def on_execute(self):
        if self.ctx[WizardBuild.name]:
            build = channel.sandbox.get_task(self.ctx[WizardBuild.name])
            if build.is_finished():
                return
            elif build.is_failure():
                raise SandboxTaskFailureError('Build task status is %s' % build.status)
            else:
                self.wait_task_completed(self.ctx[WizardBuild.name])
        else:
            raise SandboxTaskFailureError('No wizard provided')


__Task__ = WizardBeta
