# coding: utf-8

import os

import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.projects import WizardProxyGenerateReqRes as wpg

from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import util
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.errors import SandboxTaskFailureError

from sandbox.projects.common.proxy_wizard.provider import ProxyTypes
from sandbox.projects.common.proxy_wizard import executable_types as ex_types


class ProxyBuild(parameters.SandboxIntegerParameter):
    name = 'proxy_build_id'
    description = 'ProxyWizard resource ID'
    required = True


class CanonBuild(parameters.LastReleasedResource):
    name = 'canon_build_id'
    description = 'CanonWizard resource ID'
    resource_type = [ex_types.PROXY_WIZARD_CANON_EXECUTABLE]


class ConfigPath(parameters.SandboxArcadiaUrlParameter):
    name = 'config_path'
    description = 'Path to config folder'
    default_value = 'arcadia:/arc/trunk/arcadia/extsearch/wizards/fastres/config/'


class CanonAnswers(parameters.ResourceSelector):
    name = 'canon_answers'
    description = 'Canon answers'
    resource_type = [resource_types.PROXY_WIZARD_CANON_ANSWERS]
    required = False


class AnswersName(parameters.SandboxSelectParameter):
    name = 'answers_name'
    description = 'Answers name'
    required = True
    choices = [(k, k) for k in ProxyTypes.proxies.keys()]


class WizardProxyAnswersReqRes(wpg.WizardProxyGenerateReqRes):
    type = 'WIZARD_PROXY_ANSWERS_REQRES'
    client_tags = ctc.Tag.Group.LINUX

    input_parameters = (ProxyBuild, CanonBuild, ConfigPath, CanonAnswers, AnswersName)

    proxy_port = 19245
    canon_port = 19970
    storage_file = 'canon.stor'

    def _get_requests_data(self):
        generator_task_id = None

        if not self.ctx[CanonAnswers.name]:
            canon_resources = channel.sandbox.list_resources(
                resource_type=resource_types.PROXY_WIZARD_CANON_ANSWERS,
                omit_failed=True,
                status='READY',
                all_attrs={'ttl': 'inf', 'wiztype': self.ctx[AnswersName.name]},
                arch=util.system_info()['arch'],
                limit=1
            )
            if not canon_resources:
                raise SandboxTaskFailureError('Cannot find appropriate canonical answers')
            self.ctx[CanonAnswers.name] = canon_resources[0].id
            generator_task_id = canon_resources[0].task_id
        else:
            canon_resource = channel.sandbox.get_resource(self.ctx[CanonAnswers.name])
            if canon_resource and canon_resource.is_ok:
                wiztype = canon_resource.attributes['wiztype']
                if wiztype and wiztype == self.ctx[AnswersName.name]:
                    generator_task_id = canon_resource.task_id
                else:
                    raise SandboxTaskFailureError('Incorrect canon resource wiztype')
            else:
                raise SandboxTaskFailureError('Incorrect canon resource ID')

        generator_task = channel.sandbox.get_task(generator_task_id)
        if not generator_task:
            raise SandboxTaskFailureError('Cannot get task-generator')

        self.ctx['queries_resource_id'] = generator_task.ctx['queries_resource_id']
        self.ctx['limit'] = generator_task.ctx['limit']

    def _prepare_data(self):
        self._get_requests_data()
        storage_path = self.sync_resource(self.ctx[CanonAnswers.name])
        if not os.path.exists(self.storage_file):
            os.symlink(storage_path, self.storage_file)
        wpg.WizardProxyGenerateReqRes._prepare_data(self)

    def _create_links_to_canon(self, port, name):
        return 'http://localhost:{}/get/{}/?'.format(port, name)

    def _create_storage_resource(self):
        return

    def on_execute(self):
        wpg.WizardProxyGenerateReqRes.on_execute(self)


__Task__ = WizardProxyAnswersReqRes
