from sandbox.sandboxsdk import parameters
from sandbox.projects.websearch.begemot.common import Begemots


class RuntimeDataSource(parameters.SandboxStringParameter):
    '''
    usually arcadia:/arc/trunk/arcadia/search/wizard/data/fresh/
    or legacy: arcadia:/robots/trunk/wizard-data/ .
    May be a branch url.
    '''
    Robots = 'arcadia:/robots/trunk/wizard-data/'
    ArcadiaRoot = 'arcadia:/arc/trunk/arcadia'
    Arcadia = ArcadiaRoot + '/search/wizard/data/fresh/'

    name = 'runtime_data_source'
    description = 'Runtime data source'
    default_value = Arcadia
    required = False


class RuntimeLegacy(parameters.SandboxStringParameter):
    '''
    If merging, the location to merge from. Usually
    arcadia:/robots/trunk/wizard-data/
    '''
    name = 'runtime_legacy'
    description = 'Runtime legacy url'
    default_value = RuntimeDataSource.Robots
    required = False


class MergeOption(parameters.SandboxRadioParameter):
    '''This option should be deleted soon'''
    NoMerge = 'nomerge'
    Merge = 'merge'
    OnlyMerge = 'only_merge'

    name = "merge"
    description = "Merge legacy runtime to Arcadia? (REQWIZARD-965)"
    choices = [
        ('Do not merge anything, use Arcadia only', NoMerge),
        ('Merge from "Runtime legacy url" to "Runtime data source"', Merge),
        ('Merge and exit, do not build', OnlyMerge),
    ]
    default_value = NoMerge


class IgnoreSandboxConflicts(parameters.SandboxBoolParameter):
    '''
        Use when sandbox compression method changed, no md5sums match,
        and you are sure you won't lose any changes from /arc
    '''
    name = "sandbox_ignore_conflicts"
    description = 'Always overwrite sandboxed resources while merging'
    default_value = False


class DoMerge(parameters.SandboxBoolParameter):
    '''
        Merge the latest commits from /robots.
        This is done automatically every 3 hours,
        usually you do not need to enable this option manually.
        https://wiki.yandex-team.ru/begemot/fresh/#avtomjorzhilka
    '''
    name = "do_merge"
    description = 'Merge from a legacy repo to Arcadia and Sandbox'
    default_value = False


class DoCommit(parameters.SandboxBoolParameter):
    '''
        Disable if you're getting weird patches and debugging them.
        If merging, this option is required to build.
    '''
    name = "do_commit"
    description = 'Commit. Required to build if merging. Does nothing if not merging.'
    default_value = False


class DoBuild(parameters.SandboxBoolParameter):
    '''
        Build shards?
    '''
    name = "do_build"
    description = 'Build. Note that if merging, you also have to commit.'
    default_value = True


class VerboseLogs(parameters.SandboxBoolParameter):
    '''
        Produce very verbose "merge.log"
    '''
    name = "want_verbose_logs"
    description = 'More information for debugging merges'
    default_value = False


class BuildForProduction(parameters.SandboxBoolParameter):
    '''
        Create begemot packs based on production-branch shards
        instead of current shards from Arcadia.
        Set this to False in per-commit checks,
        set this to true for sandbox release scheduler.
    '''
    name = "production_build"
    description = "Build for production binary and shards"
    default_value = True


class SandboxValidationMode(parameters.SandboxBoolParameter):
    '''
        Light mode for testing new Sandbox releases (SANDBOX-5077).
        Does nothing currently.
    '''
    name = "sandbox_validation"
    description = "No-op, only sandbox testing"
    default_value = False


class RobotsRevision(parameters.SandboxIntegerParameter):
    '''default: latest'''
    name = 'runtime_data'
    description = 'Runtime data revision in the /robots repository'


class ArcadiaRevision(parameters.SandboxIntegerParameter):
    '''default: latest'''
    name = 'arcadia_revision'
    description = 'Arcadia revision to checkout'
    default = None


class ParentResources(parameters.DictRepeater, parameters.SandboxStringParameter):
    # This parameter is used by BUILD_WIZARD_2 and is not visible in the UI.
    name = 'parent_resources'
    description = 'Transfer resources to parent task (resource_type, resource_id)'


class BegemotShards(parameters.SandboxBoolGroupParameter):
    name = 'begemot_shards'
    description = 'Begemot shards to build'
    choices = [
        (sname, sname) for sname, s in Begemots
        if s.fresh_resource_name is not None
    ]
    default_value = ' '.join(i[0] for i in choices if Begemots[i[0]].release_fresh)
