# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.svn import Arcadia

from sandbox.projects import resource_types
from sandbox.projects.common import utils
from sandbox.projects.WizardRuntimeBuild import (WizardRuntimeBuild, MergeOption, RuntimeLegacy, RuntimeDataSource,
                                                 IgnoreSandboxConflicts, DoCommit)


class PatchParam(parameters.ResourceSelector):
    """
    Patch for either /robots or built runtime (after `ya make` and ./build.py)
    """
    name = 'patch_param'
    required = False
    description = 'RuntimeData Patch'
    resource_type = resource_types.WIZDATA_PATCH
    default = None


class ArcadiaPatchParam(parameters.ResourceSelector):
    """
    Direct patch for arcadia
    """
    name = 'patch_arcadia'
    required = False
    description = 'Arcadia Patch, basedir: search/wizard/data/fresh'
    default = None


_unsupported_options = (MergeOption, RuntimeLegacy, IgnoreSandboxConflicts, DoCommit)


class WizardRuntimeBuildPatched(WizardRuntimeBuild):
    """
    WIZARD_RUNTIME_BUILD + patch [SEARCHSPAM-10300]
    """
    type = 'WIZARD_RUNTIME_BUILD_PATCHED'
    input_parameters = list(filter(lambda x: x not in _unsupported_options, WizardRuntimeBuild.input_parameters + [PatchParam, ArcadiaPatchParam]))

    packed = resource_types.WIZARD_RUNTIME_PACKAGE_PATCHED
    unpacked = resource_types.WIZARD_RUNTIME_PACKAGE_UNPACKED_PATCHED

    def apply_arcadia_patch(self, path):
        patch = utils.get_or_default(self.ctx, ArcadiaPatchParam)
        if patch is not None:
            Arcadia.apply_patch_file(path, self.sync_resource(patch))

    def apply_patch(self, path):
        patch = utils.get_or_default(self.ctx, PatchParam)
        if patch is not None:
            Arcadia.apply_patch_file(path, self.sync_resource(patch))

    # This check fails on custom build paths (TODO)
    def validate_build_results(self, sources, build_output):
        pass

    def on_enqueue(self):
        self.ctx[MergeOption.name] = MergeOption.NoMerge
        self.ctx[DoCommit.name] = False
        self.ctx[RuntimeLegacy.name] = None
        # For now, the task default should be robots. Arcadia does not work yet here.
        RuntimeDataSource.default_value = RuntimeDataSource.Robots
        WizardRuntimeBuild.on_enqueue(self)


__Task__ = WizardRuntimeBuildPatched
