# -*- coding: utf-8 -*-
"""Download fresh queries (web and wizards)."""

import os
import logging

from sandbox.sandboxsdk import environments
from sandbox import sdk2
from sandbox.sdk2.helpers.process import subprocess as sp


# class WIZARDS_DESKTOP(sdk2.Resource):
#     """
#         Wizard queries for desktop.
#     """
#     any_arch = True
#     executable = False
#     releasers = ['antonka', 'osado', 'petrk']


# class WIZARDS_TOUCH(sdk2.Resource):
#     """
#         Wizard queries for touch.
#     """
#     any_arch = True
#     executable = False
#     releasers = ['antonka', 'osado', 'petrk']


# class WIZARDS_TABLET(sdk2.Resource):
#     """
#         Wizard queries for tablet.
#     """
#     any_arch = True
#     executable = False
#     releasers = ['antonka', 'osado', 'petrk']


# class WIZARDS_AGGR_DESKTOP(sdk2.Resource):
#     """
#         Wizard aggregated queries for desktop.
#     """
#     any_arch = True
#     executable = False
#     releasers = ['antonka', 'osado', 'petrk']


# class WIZARDS_AGGR_TOUCH(sdk2.Resource):
#     """
#         Wizard aggregated queries for touch.
#     """
#     any_arch = True
#     executable = False
#     releasers = ['antonka', 'osado', 'petrk']


# class WIZARDS_AGGR_TABLET(sdk2.Resource):
#     """
#         Wizard aggregated queries for tablet.
#     """
#     any_arch = True
#     executable = False
#     releasers = ['antonka', 'osado', 'petrk']


# class QUERIES_DESKTOP(sdk2.Resource):
#     """
#         Web queries for desktop.
#     """
#     any_arch = True
#     executable = False
#     releasers = ['antonka', 'osado', 'petrk']


# class QUERIES_TOUCH(sdk2.Resource):
#     """
#         Web queries for touch.
#     """
#     any_arch = True
#     executable = False
#     releasers = ['antonka', 'osado', 'petrk']


# class QUERIES_TABLET(sdk2.Resource):
#     """
#         Web queries for tablet.
#     """
#     any_arch = True
#     executable = False
#     releasers = ['antonka', 'osado', 'petrk']


# class QUERIES_AGGR_DESKTOP(sdk2.Resource):
#     """
#         Web aggregated queries for desktop.
#     """
#     any_arch = True
#     executable = False
#     releasers = ['antonka', 'osado', 'petrk']


# class QUERIES_AGGR_TOUCH(sdk2.Resource):
#     """
#         Web aggregated queries for touch.
#     """
#     any_arch = True
#     executable = False
#     releasers = ['antonka', 'osado', 'petrk']


# class QUERIES_AGGR_TABLET(sdk2.Resource):
#     """
#         Web aggregated queries for tablet.
#     """
#     any_arch = True
#     executable = False
#     releasers = ['antonka', 'osado', 'petrk']


class DownLoadWizardQueries(sdk2.Task):
    """Download daily wizard and web queries."""
    SUBPROCESS_RUNNER_NAME = 'qv_update'
    DATA_TABLE_PATH = '//home/antiwizard/query_viewer/data'

    class Requirements(sdk2.Task.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt', use_wheel=True),
        ]

    def on_execute(self):
        logging.info("Creating virtualenv")
        os.environ['YT_TOKEN'] = sdk2.Vault.data('robot_sup_hahn_token')
        os.environ['YT_PROXY'] = 'hahn.yt.yandex.net'

        with environments.VirtualEnvironment() as venv:
            environments.PipEnvironment('pip', venv=venv, version=environments.PipEnvironment.PIP_VERSION).prepare()
            # environments.PipEnvironment('yql', venv=venv, version='1.2.49', use_wheel=True).prepare()
            environments.PipEnvironment('yandex-yt', use_wheel=True).prepare()
            environments.PipEnvironment('nile[all]').prepare()

            script_path = os.path.join(
                os.path.dirname(os.path.realpath(__file__)),
                '{}.py'.format(self.SUBPROCESS_RUNNER_NAME)
            )
            process_description = [
                venv.executable,
                script_path,
            ]

            logging.info("Launching process %s", process_description)
            with sdk2.helpers.ProcessLog(self, logger=self.SUBPROCESS_RUNNER_NAME) as pl:
                p = sp.Popen(process_description, stdout=pl.stdout, stderr=pl.stderr)
                code = p.wait()

            if code != 0:
                raise RuntimeError("Process exited with code {}. Check OUT and ERR log for logger {}".format(
                    code,
                    self.SUBPROCESS_RUNNER_NAME
                ))
            else:
                self.upload_to_statface()

        logging.info("Successfully finished process execution")
