from datetime import datetime, timedelta

import yt.wrapper as ytw


def set_expiration_time(table, delay=1300):
    utc_now = datetime.utcnow()
    delayed_time = utc_now + timedelta(minutes=delay)
    delayed_time_iso = delayed_time.isoformat() + 'Z'
    ytw.set(str(table._parent.path) + '/@expiration_time', delayed_time_iso)
