# encoding:utf8

import os
import shutil
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
# import sandbox.projects.sandbox


class WoodyImageTest(sdk2.Task):
    class Requirements(sdk2.Requirements):
        privileged = True

    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group("Resources") as woody_settings:
            container = sdk2.parameters.Container(
                "Container",
                description="LXC Container with docker installed",
                default_value=140787721,
                # type=sandbox.projects.sandbox.LXC_CONTAINER,  # FIXME: invalid argument (SANDBOX-6404)
                required=True
            )

            woody_bin = sdk2.parameters.Resource(
                "Woody-check binary",
                default_value=326032988,
                required=True
            )

            ant_secret_bin = sdk2.parameters.Resource(
                "Ant-Secret binary",
                default_value=326011237,
                required=True
            )

        image = sdk2.parameters.String(
            "Docker image to check"
        )

        suspend = sdk2.parameters.Bool(
            "Suspend task",
            default_value=False
        )

    def _mk_base_dir(self, wrkdir):
        woody = os.path.join(wrkdir, ".woody")
        if not os.path.isdir(woody):
            os.mkdir(woody)

        tools = os.path.join(woody, "tools")
        if not os.path.isdir(tools):
            os.mkdir(tools)

    def _check_docker_available(self):
        with sdk2.helpers.ProcessLog(self, logger="docker_start_call") as l:
            sp.check_call(["service", "docker", "start"], stdout=l.stdout, stderr=l.stderr)

        # check docker is OK
        with sdk2.helpers.ProcessLog(self, logger="docker_version_call") as l:
            sp.check_call(["docker", "version"], stdout=l.stdout, stderr=l.stderr)

    def on_execute(self):
        if self.Parameters.suspend:
            self.suspend()

        # check docker is available
        self._check_docker_available()
        self.work_dir = str(self.path('.'))
        self._mk_base_dir(self.work_dir)

        resource_ant_secret = sdk2.ResourceData(self.Parameters.ant_secret_bin)
        shutil.copyfile(str(resource_ant_secret.path), os.path.join(self.work_dir, ".woody", "tools", "ant-secret"))

        resource_woody = sdk2.ResourceData(self.Parameters.woody_bin)
        shutil.copyfile(str(resource_woody.path), os.path.join(self.work_dir, "woody-check"))

        username = "robot-bishop"
        password = sdk2.Vault.data(self.owner, 'robot-bishop-registry-token')

        env = {
            "DOCKER_USER": username,
            "DOCKER_PASSWORD": password
        }

        with sdk2.helpers.ProcessLog(self, logger="woody-check") as l:
            sp.Popen(["woody-check", "test", "--image", self.Parameters.image],
                     stdout=l.stdout, stderr=l.stderr, env=env).wait()
