import logging
from sandbox import sdk2
from sandbox.projects.WtoQloud.build_docker import BuildDockerImageWto
from sandbox.projects.WtoQloud.deploy_to_qloud import DeployToQloudWto
import sandbox.common.types.task as ctt
from sandbox import common


class WtoQloud(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        container = 1253542152  # 26
        disk_space = 5 * 1024

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group("Teamcity parameters") as teamcity_block:
            # teamcity_build_id = sdk2.parameters.String("teamcity_build_id ", required=True)
            teamcity_build_number = sdk2.parameters.String("teamcity_build_number", default="")
            app_name = sdk2.parameters.String("app_name", required=True)
            release_version = sdk2.parameters.String("release_version", required=True)
            build_configuration_id = sdk2.parameters.String("build_configuration_id", required=True)

    def on_execute(self):
        logging.info('Start task to making docker image')
        app_name = self.Parameters.app_name
        with self.memoize_stage.create_docker:
            docker = BuildDockerImageWto(
                self,
                description="Child of {}".format(self.id),
                owner="OEBS-QA",  # required fields cannot be empty,
                repository="ssh://git@bb.yandex-team.ru/oebs-qa/wto-docker.git",
                ssh_vault_name="env.robot_obs_qa_ssh",
                ssh_vault_owner="OEBS-QA",
                registry_tags="registry.yandex.net/oebs-qa/{0}-qloud-image:{1}-{2}".format(app_name,
                                                                                           self.Parameters.release_version,
                                                                                           self.Parameters.teamcity_build_number),
                oauth_vault_name="env.token_registry_oebs_qa_robot",
                oauth_vault_owner="OEBS-QA",
                registry_login="robot-oebs-qa",
                # docker_build_args=["BUILD_ID={}".format(self.Parameters.teamcity_build_id)],
                path_to_dockerfile="{0}-qloud-image".format(app_name),
                teamcity_build_number=self.Parameters.teamcity_build_number,
                app_name=app_name,
                release_version=self.Parameters.release_version,
                build_configuration_id=self.Parameters.build_configuration_id
            )
            docker.enqueue()
            self.Context.sub_task_id = docker.id
            raise sdk2.WaitTask([docker], ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True)
        with self.memoize_stage.deploy_qloud:
            sub_task = self.find(id=self.Context.sub_task_id).first()
            if sub_task.status not in ctt.Status.Group.SUCCEED:
                raise common.errors.TaskFailure("Subtask is failed with status {}".format(sub_task.status))
            qloud = DeployToQloudWto(
                self,
                description="Child of {}".format(self.id),
                owner="OEBS-QA",  # required fields cannot be empty,
                qloud_component_path="oebs-qa.common.wto.{}".format(app_name),
                image_tag="registry.yandex.net/oebs-qa/{0}-qloud-image:{1}-{2}".format(app_name,
                                                                                       self.Parameters.release_version,
                                                                                       self.Parameters.teamcity_build_number),
                qloud_token_vault_name="ENV.QLOUD_OAUTH_TOKEN_WTO",
                release_version="{}".format(self.Parameters.release_version),
                comment="Sandbox deploy by {}, task id - {} ,app:{}, r.v. -  {}, b.n. - {}".format(self.author, self.id,
                                                                                                   self.Parameters.app_name,
                                                                                                   self.Parameters.release_version,
                                                                                                   self.Parameters.teamcity_build_number)
            )
            qloud.enqueue()
            self.Context.sub_task_id = qloud.id
            raise sdk2.WaitTask([qloud], ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True)
        with self.memoize_stage.finish:
            sub_task = self.find(id=self.Context.sub_task_id).first()
            if sub_task.status not in ctt.Status.Group.SUCCEED:
                raise common.errors.TaskFailure("Subtask is failed with status {}".format(sub_task.status))
