from sandbox import sdk2
from sandbox.sdk2 import svn
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.common.environments import SandboxJavaJdkEnvironment
from sandbox.projects.common.environments import SandboxMavenEnvironment


class XMLSEARCH_COUNTER_BINARY(sdk2.Resource):
    """
    Xmlsearch counter jars
    """
    releasers = ['avhaliullin', 'ifilippov5']
    releasable = True


class BuildXmlSearchCounter(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [SandboxJavaJdkEnvironment('1.8.0'), SandboxMavenEnvironment('3.2.2')]

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.String('revision', default=None, description='Arcadia revision')

    def on_execute(self):
        clone_path = unicode(self.path('xmlsearch'))
        svn.Arcadia.checkout('arcadia:/arc/trunk/arcadia/xmlsearch', clone_path, revision=self.Parameters.svn_revision)

        with sdk2.helpers.ProcessLog(self, logger="mvn") as pl:
            process = sp.Popen(
                [
                    'mvn',
                    '-Djava.net.preferIPv4Stack=false',
                    '-Djava.net.preferIPv6Addresses=true',
                    '-s', 'settings.xml',
                    '-f', 'counter-assembly',
                    'clean',
                    'package'
                ],
                cwd=clone_path, stdout=pl.stdout
            )
            process.timeout = 10800
            process.wait()

        resource = XMLSEARCH_COUNTER_BINARY(self, "Xmlsearch counter jars", unicode(self.path('xmlsearch/counter-assembly/target/assembly/lib/')))
        sdk2.ResourceData(resource).ready()
