import os

from sandbox import sdk2
from sandbox import common
from sandbox.sdk2.helpers import subprocess as sp

TANKER_API_URL = "https://tanker-api.yandex-team.ru/tools/"


class XmlSearchTranslations(sdk2.Resource):
    releasers = ['leonidrom', 'robot-webmaster']
    releasable = True
    any_arch = True
    platform = 'any'
    ttl = 'inf'


class XmlSearchCollectTranslations(sdk2.Task):
    class Parameters(sdk2.Parameters):
        tokens = sdk2.parameters.YavSecret(
            "XML Search secrets (for Tanker token)"
        )

    def fetch_file(self, token, path, out_file_name):
        p = sp.Popen([
            'curl', '-o', out_file_name,
            '-H', 'Authorization: OAuth ' + token,
            TANKER_API_URL + path])
        exit_code = p.wait()
        if exit_code != 0:
            raise common.errors.TaskError("Error running curl, exiting")

    def fetch_backend_xsl(self, token, i18n_path, locale):
        locale_path = i18n_path + locale + '/'
        if not os.path.exists(locale_path):
            os.makedirs(locale_path)
        self.fetch_file(token, 'generate/i18n.xml?status=unapproved&safe=ru&project-id=xml&language=' + locale +
                               '&keyset-id=backend&path=i18n&type=xsl&branch-id=master', locale_path + 'xml.backend.xsl')

    def on_execute(self):
        tokens = self.Parameters.tokens.data()
        token = tokens["tanker.token"]

        i18n_path = os.getcwd() + '/i18n/'
        if not os.path.exists(i18n_path):
            os.makedirs(i18n_path)

        self.fetch_file(token, 'i18n/rebuild-xsl?status=unapproved&safe=ru&', i18n_path + 'rebuild.xsl')
        self.fetch_file(token, 'i18n/page-xml?status=unapproved&safe=ru&', i18n_path + 'page.xml')
        self.fetch_file(token, 'i18n/common-xsl?status=unapproved&safe=ru&', i18n_path + 'common.xsl')
        self.fetch_file(token, 'i18n/lego.common-xsl?status=unapproved&safe=ru&', i18n_path + 'lego.common.xsl')
        self.fetch_file(token, 'generate/i18n.common.xml?status=unapproved&safe=ru&;project-id=xml', i18n_path + 'common.xml')

        self.fetch_backend_xsl(token, i18n_path, "be")
        self.fetch_backend_xsl(token, i18n_path, "en")
        self.fetch_backend_xsl(token, i18n_path, "kk")
        self.fetch_backend_xsl(token, i18n_path, "ru")
        self.fetch_backend_xsl(token, i18n_path, "tr")
        self.fetch_backend_xsl(token, i18n_path, "tt")
        self.fetch_backend_xsl(token, i18n_path, "uk")

        p = sp.Popen(['tar', 'czf', 'translations.tar.gz', 'i18n'])
        exit_code = p.wait()
        if exit_code != 0:
            raise common.errors.TaskError("Error creating archive, exiting")

        resource = XmlSearchTranslations(self, "Translations archive", unicode(self.path('translations.tar.gz')))
        sdk2.ResourceData(resource).ready()
