#!/usr/bin/env python
# -*- coding: utf8 -*-

import textwrap
import logging
import datetime

from optparse import OptionParser
from yql.api.v1.client import YqlClient
import yt.wrapper as yt

RESULT_TABLE = "//home/yabs-rt/ads-verify/mediascope"
YT_CLUSTER = "hahn"

"""
По js-taracer-verify-log собираем показы баннеров.
Результирующую таблицу сохраняем на YT.
Отправкой на FTP занимается отдельный скрипт
"""


logging.basicConfig(
    level=logging.INFO,
    format='[%(levelname)s %(asctime)s]: %(message)s',
    datefmt='%m-%d-%Y %I:%M:%S'
)


def get_uids():
    parser = OptionParser()
    parser.add_option("--yql_token", help="YQL auth token")
    parser.add_option("--yt_token", help="YT auth token")
    options = parser.parse_args()[0]

    YQL_TOKEN = options.yql_token
    YT_TOKEN = options.yt_token

    yt.config['token'] = YT_TOKEN

    logging.info("get_uids")

    client = YqlClient(
        db=YT_CLUSTER,
        token=YQL_TOKEN,
    )

# Ищем дату, за которую нужно собрать агрегированный суточный лог:
# - если данные есть - находим из имени файла даты, находим самую последнюю дату и прибавляем к ней день
# - если данных нет - собираем лог за сегодняшний день

    l = yt.list("//home/yabs-rt/ads-verify/mediascope")
    a = [x[10:] for x in l if 'AdsVerify_' in x]
    a.sort(reverse=True)

    logging.info(a)
    if len(a) > 0:
        log_date = datetime.date(int(a[0][:-9]), int(a[0][5:-6]), int(a[0][8:-3]))
    else:
        log_date = datetime.datetime.now() - datetime.timedelta(days=1)
    next_date = log_date + datetime.timedelta(days=1)

    logging.info(next_date.strftime("%Y-%m-%d"))

    if next_date.strftime("%Y-%m-%d") <= datetime.datetime.now().strftime("%Y-%m-%d"):
        request = client.query(textwrap.dedent(
            """
            insert into [home/yabs-rt/tudalova/tns/AdsVerifyLog_%s]
            select
                ServerTimestamp as EventTime,
                UserAgent,
                ClientIP,
                HTTPVertion,
                Null as Location,
                Null as AppBundle,
                Null as DeviceType,
                Null as RND,
                Null as Customdata,
                Null as AdParams
            from
                `logs/jstracer-test-verify-log/1d/%s`;
            """) % (
                next_date.strftime("%Y-%m-%d"), next_date.strftime("%Y-%m-%d")
            )
        )
        request.run()

        if not request.get_results().is_success:
            error_description = '\n'.join([str(err) for err in request.get_results().errors])
            logging.error(error_description)
            raise RuntimeError(error_description)
        logging.info("get_uids: verify log created")
    else:
        logging.info("get_uids: no jstracer loges")


if __name__ == "__main__":
    get_uids()
