# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import SandboxFloatParameter

from sandbox.projects.YabsBscountPerformance import YabsBscountPerformance
from sandbox.projects.common.TestPerformanceBest import BaseTestPerformanceBestTask


class SubtasksExecutionSpace(SandboxFloatParameter):
    name = 'subtasks_execution_space'
    description = 'Execution space of subtasks'


class YabsBscountPerformanceBest(BaseTestPerformanceBestTask):
    """
    Runs number_of_runs YabsBscountPerformance subtasks
    and selects the best result.
    """

    type = 'YABS_BSCOUNT_PERFORMANCE_BEST'
    execution_space = 100

    input_parameters = (
        (SubtasksExecutionSpace,) +
        BaseTestPerformanceBestTask.input_parameters +
        YabsBscountPerformance.input_parameters
    )

    def _get_performance_task_type(self):
        return YabsBscountPerformance.type

    def _get_subtasks_execution_space(self):
        return self.ctx.get(SubtasksExecutionSpace.name)

    # FIXME
    # use this hack for a local sandbox
    # def on_execute(self):
        # self.cpu_model_filter = 'E312xx'
        # BaseTestPerformanceBestTask.on_execute(self)


__Task__ = YabsBscountPerformanceBest
