# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import parameters

from sandbox.projects.YabsBscountPerformanceBest import YabsBscountPerformanceBest
from sandbox.projects.common.yabs.performance_best_cmp import YabsPerformanceBestCmp
from sandbox.projects.common.yabs.performance_best_cmp import MaxReqsDiffPercent
from sandbox.projects.common.yabs.performance_best_cmp import MaxMemDiffPercent
from sandbox.projects.common.yabs.performance_best_cmp import ImprovementIsDiff


class PreResult(parameters.TaskSelector):
    task_type = YabsBscountPerformanceBest.type
    group = 'YabsBscountPerformanceBest tasks'
    name = 'pre_task_id'
    description = 'Task 1 (baseline) '


class TestResult(parameters.TaskSelector):
    task_type = YabsBscountPerformanceBest.type
    group = 'YabsBscountPerformanceBest tasks'
    name = 'test_task_id'
    description = 'Task 2 (test)'


class YabsBscountPerformanceBestCmp(YabsPerformanceBestCmp):
    type = 'YABS_BSCOUNT_PERFORMANCE_BEST_CMP'
    description = 'Compare yabs-bscount performance test results'
    input_parameters = [PreResult, TestResult, MaxReqsDiffPercent, MaxMemDiffPercent, ImprovementIsDiff]

    def on_execute(self):
        pre_ctx, test_ctx = self._get_ctxes(PreResult, TestResult)
        self._make_report(pre_ctx, test_ctx, description='Yabs bscount B2B load test diff')


__Task__ = YabsBscountPerformanceBestCmp
